<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys'])) {
  header('Location: login.php');
  exit;
}
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if ($id <= 0) {
  header('Location: accounts.php');
  exit;
}
// get account details
$account_details = mysqli_query($con, "SELECT * FROM accounts WHERE id={$id}");
if (!$account_details || mysqli_num_rows($account_details) < 1) {
  header('Location: accounts.php');
  exit;
}
$row_account = mysqli_fetch_assoc($account_details);
$account_id = (int) ($row_account['id'] ?? 0);
$account_title = $row_account['title'] ?? '';
$account_number = $row_account['acc_number'] ?? '';

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">

  <link rel="shortcut icon" href="#" type="image/png">

  <title>General Ledger Transactions</title>
  <link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/bootstrap-fullcalendar.css" rel="stylesheet" />
<link href="js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="js/data-tables/DT_bootstrap.css" />
  <script src="ckeditor/ckeditor.js"></script>
  <link href="css/style.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">
  <link href="datapicker/datepicker3.css" rel="stylesheet">
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->
        
        <div class="row">
        
    <div class="col-lg-11">
      
                      <section class="panel">
                    <header class="panel-heading">
                  General Ledger Tranasctions For <?php echo htmlspecialchars($account_title . ' (' . $account_number . ')'); ?>
                    </header>
                  <div class="panel-body">
                    <?php
                        $transactions = mysqli_query($con, "SELECT * FROM accounts_transactions WHERE status=1 AND account_id={$account_id} ORDER BY id DESC");
                        if ($transactions && mysqli_num_rows($transactions) > 0) {
?>
         <table  class="display table  table-striped" id="dynamic-table-2">
      <thead>
      <tr>
          <th>Date</th>
          <th>Account</th>
          <th>Description</th>
           <th>Debited</th>
           <th>Credited</th>
                  <!-- <?php
              if($_SESSION['schoolsyslevel']==1){
                              ?>
                       <th>Action</th>
              <?php }?> -->
            </tr>
      </thead>
      <tbody>
         <?php
                        while ($row = mysqli_fetch_assoc($transactions)) {
                           $transactions_id = (int) ($row['id'] ?? 0);
                           $date = isset($row['date']) ? (int) $row['date'] : 0;
                           $txn_account_id = (int) ($row['account_id'] ?? 0);
                           $entry_wording = $row['entry_wording'] ?? '';
                           $type = $row['type'] ?? '';
                           $amount = $row['amount'] ?? 0;

          ?>
              <tr class="gradeA">
                   <td><?php echo htmlspecialchars(date('d/M/y', $date)); ?></td>
                          <td><?php
                        $acc_single = mysqli_query($con, "SELECT * FROM accounts WHERE id={$txn_account_id}");
                        $row_acc = $acc_single ? mysqli_fetch_assoc($acc_single) : null;
                          echo htmlspecialchars(($row_acc['title'] ?? '') . ' ' . ($row_acc['acc_number'] ?? ''));
                          ?></td>
                          <td>
                           <?php echo htmlspecialchars($entry_wording);  ?>
                          </td>
                           <td>
                              <?php
                              if($type=='1'){
                              echo htmlspecialchars((string)$amount);
                              }
                              ?>
                           </td>
                           <td>
                              <?php
                              if($type=='2'){
                              echo htmlspecialchars((string)$amount);
                              }
                              ?>
                           </td>

                     
                                                                     
  <!-- <td> 
      <?php
              if($_SESSION['schoolsyslevel']==1){
                              ?>
        <a data-toggle="modal" href="#modal-form<?php echo $transactions_id; ?>"  class="btn btn-info  btn-xs">Edit <i class="fa fa-edit"></i></a>   
       <a href="removetransaction?cl=<?php echo $transactions_id; ?>"  class="btn btn-danger  btn-xs" onclick="return confirm_delete<?php echo $transactions_id;?>()">Remove <i class="fa fa-trash-o"></i></a>    
         <script type="text/javascript">
function confirm_delete<?php echo $transactions_id; ?>() {
  return confirm('You are about To Remove this item. Are you sure you want to proceed?');
}
</script>   
  <?php } ?>
  </td> -->
 
              </tr>
                    
            <?php } ?>
              </tbody>
                        </table>
 <?php } else {?>
   <div class="alert alert-danger">No Transactions Found</div>
   <?php }?>
                          </div>
                            </section>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
     

    </div>
    <!-- main content end-->
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script src="js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="js/jquery-migrate-1.2.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/modernizr.min.js"></script>
<script src="js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="js/data-tables/DT_bootstrap.js"></script>
<script src="js/dynamic_table_init.js"></script>
<script src="datapicker/bootstrap-datepicker.js"></script>
<!--common scripts for all pages-->
<script src="js/scripts.js"></script>
<!-- set date to order in desc with datatable  -->
<script type="text/javascript">
$(document).ready(function() {
    $('#dynamic-table-2').dataTable( {
        "aaSorting": [[ 0, "desc" ]]
    } );
    $('#data_1 .input-group.date').datepicker({
                todayBtn: "linked",
                keyboardNavigation: false,
                forceParse: false,
                calendarWeeks: true,
                autoclose: true
            });
});
</script>
</body>
</html>
