<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
}
// session guard and cast/validate session values
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
$class_id = (int)($_SESSION['class_id'] ?? 0);

// fetch class name safely
$class = '';
$class_stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($class_stmt) {
    mysqli_stmt_bind_param($class_stmt, 'i', $class_id);
    mysqli_stmt_execute($class_stmt);
    $cres = mysqli_stmt_get_result($class_stmt);
    if ($cres && ($crow = mysqli_fetch_assoc($cres))) {
        $class = $crow['class'] ?? '';
    }
    mysqli_stmt_close($class_stmt);
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title>Class Teacher Comment | School Manager</title>
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php'; ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">

        <div class="col-lg-12">
          <section class="panel">
            <header class="panel-heading">
              End of Term Student Comments
            </header>
            <div class="panel-body">
              <table class="display table  table-striped" id="dynamic-table">
                <thead>
                  <tr>
                    <th>Student</th>
                    <th>Term </th>
                    <th>Class</th>
                    <!-- <th>Subject</th> -->
                    <!-- <th>Topics Covered</th> -->
                    <th>Comments</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>

                  <?php
                  // prepared statement to fetch reports for this teacher
                  $reports_stmt = mysqli_prepare($con, "SELECT subjecttermreport_id, class_id, report, timestamp, student_id, teacher_id, term_id FROM subjecttermreports WHERE teacher_id = ? AND status = 1 ORDER BY timestamp DESC");
                  if ($reports_stmt) {
                      mysqli_stmt_bind_param($reports_stmt, 'i', $teacher_id);
                      mysqli_stmt_execute($reports_stmt);
                      $rres = mysqli_stmt_get_result($reports_stmt);

                      // prepared statements for lookups (reuse)
                      $class_lookup = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
                      $teacher_lookup = mysqli_prepare($con, "SELECT fullname FROM teachers WHERE teacher_id = ? LIMIT 1");
                      $term_lookup = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
                      $student_lookup = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ? LIMIT 1");

                      while ($row = mysqli_fetch_assoc($rres)) {
                          $subjecttermreport_id = (int)($row['subjecttermreport_id'] ?? 0);
                          $class_id_row = (int)($row['class_id'] ?? 0);
                          $report = $row['report'] ?? '';
                          $timestamp = $row['timestamp'] ?? '';
                          $student_id_row = (int)($row['student_id'] ?? 0);
                          $teacher_id_row = (int)($row['teacher_id'] ?? 0);
                          $term_id = (int)($row['term_id'] ?? 0);

                          // lookup class
                          $class2 = '';
                          $category_id = 0;
                          if ($class_lookup) {
                              mysqli_stmt_bind_param($class_lookup, 'i', $class_id_row);
                              mysqli_stmt_execute($class_lookup);
                              $cres = mysqli_stmt_get_result($class_lookup);
                              if ($cres && ($crow = mysqli_fetch_assoc($cres))) {
                                  $class2 = $crow['class'] ?? '';
                                  $category_id = (int)($crow['category_id'] ?? 0);
                              }
                          }

                          // lookup teacher fullname (not used currently but kept)
                          $fname = '';
                          if ($teacher_lookup) {
                              mysqli_stmt_bind_param($teacher_lookup, 'i', $teacher_id_row);
                              mysqli_stmt_execute($teacher_lookup);
                              $tres = mysqli_stmt_get_result($teacher_lookup);
                              if ($tres && ($trow = mysqli_fetch_assoc($tres))) {
                                  $fname = $trow['fullname'] ?? '';
                              }
                          }

                          // lookup term
                          $term2 = '';
                          $year = '';
                          if ($term_lookup) {
                              mysqli_stmt_bind_param($term_lookup, 'i', $term_id);
                              mysqli_stmt_execute($term_lookup);
                              $tres = mysqli_stmt_get_result($term_lookup);
                              if ($tres && ($trow = mysqli_fetch_assoc($tres))) {
                                  $term2 = $trow['term'] ?? '';
                                  $year = $trow['year'] ?? '';
                              }
                          }

                          // lookup student
                          $fullname = '';
                          if ($student_lookup) {
                              mysqli_stmt_bind_param($student_lookup, 'i', $student_id_row);
                              mysqli_stmt_execute($student_lookup);
                              $sres = mysqli_stmt_get_result($student_lookup);
                              if ($sres && ($srow = mysqli_fetch_assoc($sres))) {
                                  $fullname = $srow['fullname'] ?? '';
                              }
                          }

                  ?>
                    <tr class="gradeA">
                      <td><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></td>
                      <td><?php echo htmlspecialchars($term2 . ' ' . $year, ENT_QUOTES); ?></td>
                      <td><?php echo htmlspecialchars($class2, ENT_QUOTES); ?></td>
                      <td><?php echo htmlspecialchars($report, ENT_QUOTES); ?></td>
                      <td>
                        <a href="editsubjectreport?id=<?php echo htmlspecialchars($subjecttermreport_id, ENT_QUOTES); ?>" class="btn btn-info btn-xs">Edit</a>
                      </td>
                    </tr>
                    <script type="text/javascript">
                      function confirm_delete<?php echo $subjecttermreport_id; ?>() {
                        return confirm('You are about To Remove this Item. Are you sure you want to proceed?');
                      }
                    </script>
                  <?php }

                      if ($reports_stmt) mysqli_stmt_close($reports_stmt);
                      if ($class_lookup) mysqli_stmt_close($class_lookup);
                      if ($teacher_lookup) mysqli_stmt_close($teacher_lookup);
                      if ($term_lookup) mysqli_stmt_close($term_lookup);
                      if ($student_lookup) mysqli_stmt_close($student_lookup);
                  }
                  ?>
                </tbody>
              </table>
            </div>
        </div>

      </div>


      </div>
      <!-- page end-->
    </section>
    <!--body wrapper end-->

    <!--footer section start-->

    <!--footer section end-->


    </div>
    <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
  <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
  <!--common scripts for all pages-->
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>

</body>

</html>