<?php
// teacher/subject.php - modernized and lint-clean implementation
include '../includes/conn.php';

// session guard (conn.php should start session; keep guard here)
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}

// validate and cast GET params
$sub = filter_input(INPUT_GET, 'sub', FILTER_VALIDATE_INT);
$cl = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
$sub = $sub === false || $sub === null ? 0 : (int)$sub;
$cl = $cl === false || $cl === null ? 0 : (int)$cl;

// initialize variables
$class = '';
$category_id = 0;
$subject = '';
$class_sub_id = 0;

// fetch class info
$class_stmt = mysqli_prepare($con, "SELECT class, category_id FROM classes WHERE class_id = ? LIMIT 1");
if ($class_stmt) {
    mysqli_stmt_bind_param($class_stmt, 'i', $cl);
    mysqli_stmt_execute($class_stmt);
    $cres = mysqli_stmt_get_result($class_stmt);
    if ($cres && ($crow = mysqli_fetch_assoc($cres))) {
        $class = $crow['class'] ?? '';
        $category_id = (int)($crow['category_id'] ?? 0);
    }
    mysqli_stmt_close($class_stmt);
}

// fetch subject
$sub_stmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
if ($sub_stmt) {
    mysqli_stmt_bind_param($sub_stmt, 'i', $sub);
    mysqli_stmt_execute($sub_stmt);
    $sres = mysqli_stmt_get_result($sub_stmt);
    if ($sres && ($srow = mysqli_fetch_assoc($sres))) {
        $subject = $srow['subject'] ?? '';
    }
    mysqli_stmt_close($sub_stmt);
}

// fetch class_subject id
$cs_stmt = mysqli_prepare($con, "SELECT class_sub_id FROM class_subjects WHERE class_id = ? AND subject_id = ? LIMIT 1");
if ($cs_stmt) {
    mysqli_stmt_bind_param($cs_stmt, 'ii', $cl, $sub);
    mysqli_stmt_execute($cs_stmt);
    $csres = mysqli_stmt_get_result($cs_stmt);
    if ($csres && ($csrow = mysqli_fetch_assoc($csres))) {
        $class_sub_id = (int)($csrow['class_sub_id'] ?? 0);
    }
    mysqli_stmt_close($cs_stmt);
}

?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($subject . ' : ' . $class, ENT_QUOTES); ?> | School Manager</title>
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>
<body>
<section>
    <?php include 'nav.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <a href="addweeklyplan?id=<?php echo htmlspecialchars($class_sub_id, ENT_QUOTES); ?>" class="btn btn-info">Add Lesson Plan</a>
                <br /><br />
                <section class="panel">
                    <header class="panel-heading">
                        <?php echo htmlspecialchars($subject . ' : ' . $class, ENT_QUOTES); ?> Lesson Weekly Plans
                    </header>
                    <div class="panel-body">
                        <table class="display table table-striped" id="dynamic-table">
                            <thead>
                                <tr>
                                    <th>From</th>
                                    <th>To</th>
                                    <th>Term</th>
                                    <?php if ($category_id == 3) { ?>
                                        <th>Book Pages</th>
                                    <?php } else { ?>
                                        <th>Year</th>
                                        <th>Periods per Week</th>
                                    <?php } ?>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
<?php
// fetch weekly plans for this class_subject and teacher
$teacher_id = (int)($_SESSION['teachersys'] ?? 0);
$wp_stmt = mysqli_prepare($con, "SELECT weeklyplan_id, startdate, enddate, periodsperweek, bookpages, term FROM weeklyplans WHERE class_sub_id = ? AND teacher_id = ? AND status = 1 ORDER BY startdate DESC");
$term_stmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
if ($wp_stmt) {
    mysqli_stmt_bind_param($wp_stmt, 'ii', $class_sub_id, $teacher_id);
    mysqli_stmt_execute($wp_stmt);
    $wres = mysqli_stmt_get_result($wp_stmt);
    while ($row = mysqli_fetch_assoc($wres)) {
        $weeklyplan_id = (int)($row['weeklyplan_id'] ?? 0);
        $startdate = (int)($row['startdate'] ?? 0);
        $enddate = (int)($row['enddate'] ?? 0);
        $periodsperweek = htmlspecialchars($row['periodsperweek'] ?? '', ENT_QUOTES);
        $bookpages = htmlspecialchars($row['bookpages'] ?? '', ENT_QUOTES);
        $term_value = (int)($row['term'] ?? 0);

        $term = '';
        $year = '';
        if ($term_stmt) {
            mysqli_stmt_bind_param($term_stmt, 'i', $term_value);
            mysqli_stmt_execute($term_stmt);
            $tres = mysqli_stmt_get_result($term_stmt);
            if ($tres && ($trow = mysqli_fetch_assoc($tres))) {
                $term = $trow['term'] ?? '';
                $year = $trow['year'] ?? '';
            }
        }
?>
                                <tr class="gradeA">
                                    <td><?php echo $startdate ? date('d/M/Y', $startdate) : ''; ?></td>
                                    <td><?php echo $enddate ? date('d/M/Y', $enddate) : ''; ?></td>
                                    <td>Term <?php echo htmlspecialchars($term, ENT_QUOTES); ?></td>
                                    <?php if ($category_id == 3) { ?>
                                        <td><?php echo $bookpages; ?></td>
                                    <?php } else { ?>
                                        <td><?php echo htmlspecialchars($year, ENT_QUOTES); ?></td>
                                        <td><?php echo $periodsperweek; ?></td>
                                    <?php } ?>
                                    <td>
                                        <a href="weeklyplan?id=<?php echo htmlspecialchars($weeklyplan_id, ENT_QUOTES); ?>" class="btn btn-success btn-xs">Details</a>
                                        <a href="removeweeklyplan?id=<?php echo htmlspecialchars($weeklyplan_id, ENT_QUOTES); ?>" class="btn btn-danger btn-xs" onclick="return confirm('You are about to remove this weekly plan. Proceed?')">Remove</a>
                                    </td>
                                </tr>
<?php
    }
    if ($wp_stmt) mysqli_stmt_close($wp_stmt);
    if ($term_stmt) mysqli_stmt_close($term_stmt);
}
?>
                            </tbody>
                        </table>
                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<!-- scripts -->
<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>
</html>