<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
   header('Location:login.php');
   exit;
}

// validate id
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
   header('Location: unseeninquiries.php');
   exit;
}

// fetch inquiry using prepared statement
$inquiry_id = null;
$parent_id = null;
$type = null;
$recipient = null;
$inquiry = '';
$timestamp = null;
$stmt = mysqli_prepare($con, "SELECT * FROM inquiries WHERE inquiry_id = ? LIMIT 1");
if ($stmt) {
   mysqli_stmt_bind_param($stmt, 'i', $id);
   mysqli_stmt_execute($stmt);
   $res = mysqli_stmt_get_result($stmt);
   $row = mysqli_fetch_assoc($res);
   mysqli_stmt_close($stmt);
} else {
   $row = null;
}

if (!$row) {
   header('Location: unseeninquiries.php');
   exit;
}

$inquiry_id = $row['inquiry_id'];
$parent_id = (int)$row['parent_id'];
$type = $row['type'];
$recipient = $row['recipient'];
$inquiry = strip_tags($row['inquiry']);
$timestamp = $row['timestamp'];

// fetch parent name
$fullname = '';
$stmt = mysqli_prepare($con, "SELECT * FROM parents WHERE parent_id = ? LIMIT 1");
if ($stmt) {
   mysqli_stmt_bind_param($stmt, 'i', $parent_id);
   mysqli_stmt_execute($stmt);
   $res = mysqli_stmt_get_result($stmt);
   $row1 = mysqli_fetch_assoc($res);
   mysqli_stmt_close($stmt);
   if ($row1) {
      $fullname = $row1['parent_name'];
   }
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Reply to Inquiry from <?php echo $fullname; ?></title>
     <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
   <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">
    <!--<link href="css/plugins/iCheck/custom.css" rel="stylesheet">-->
    <link href="<?php echo BASE_URL; ?>./css/animate.css" rel="stylesheet">
      <link href="<?php echo BASE_URL; ?>./css/plugins/chosen/chosen.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
   <link href="<?php echo BASE_URL; ?>/css/plugins/datapicker/datepicker3.css" rel="stylesheet">
 <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" type="text/css" rel="stylesheet" />
</head>

<body>

    <div id="wrapper">

        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
          
        </div>
            <ul class="nav navbar-top-links navbar-right">
               
               <?php
               if (isset($_POST['notification'])) {
                   $notification = $_POST['notification'] ?? '';
                   $notification = trim($notification);
                   $errors = [];

                   if (empty($notification)) {
                       $errors[] = 'All Fields are Required';
                   }

                   if (!empty($errors)) {
                       foreach ($errors as $error) {
                           echo '<div class="alert alert-danger">' . htmlspecialchars($error, ENT_QUOTES) . '</div>';
                       }
                   } else {
                       // insert notification (prepared)
                       $sender = (int)($_SESSION['teachersys'] ?? 0);
                       $sendertype = 'Teachers';
                       $messagetype = 'single';
                       $status = 1;
                       $tstamp = $timenow ?? date('Y-m-d H:i:s');

                       $stmt = mysqli_prepare($con, "INSERT INTO notifications (notification,sender,sendertype,messagetype,reciever,timestamp,status) VALUES(?,?,?,?,?,?,?)");
                       if ($stmt) {
                           mysqli_stmt_bind_param($stmt, 'sissisi', $notification, $sender, $sendertype, $messagetype, $parent_id, $tstamp, $status);
                           mysqli_stmt_execute($stmt);
                           mysqli_stmt_close($stmt);
                       }
                       $last_id = mysqli_insert_id($con);

                       $stmt = mysqli_prepare($con, "INSERT INTO recipients(notification_id,parent_id,status) VALUES(?,?,?)");
                       if ($stmt) {
                           $zero = 0;
                           mysqli_stmt_bind_param($stmt, 'iii', $last_id, $parent_id, $zero);
                           mysqli_stmt_execute($stmt);
                           mysqli_stmt_close($stmt);
                       }

                       // get parent for email
                       $parentnames = [];
                       $emails = [];
                       $stmt = mysqli_prepare($con, "SELECT * FROM parents WHERE parent_id = ? AND status = 1 LIMIT 1");
                       if ($stmt) {
                           mysqli_stmt_bind_param($stmt, 'i', $parent_id);
                           mysqli_stmt_execute($stmt);
                           $res = mysqli_stmt_get_result($stmt);
                           if ($roww = mysqli_fetch_assoc($res)) {
                               $parentnames[] = $roww['parent_name'];
                               $emails[] = $roww['email'];
                           }
                           mysqli_stmt_close($stmt);
                       }

                       $to = implode(", ", $emails);
                       $parentname = implode(", ", $parentnames);
                       $subject = "HARVEST ACADEMY NOTIFICATION";

                       $message = <<<'EOT'
   <style type="text/css">
            /* Client-specific Styles */
            #outlook a {padding:0;} /* Force Outlook to provide a "view in browser" menu link. */
            body{width:100% !important; -webkit-text-size-adjust:100%; -ms-text-size-adjust:100%; margin:0; padding:0;}
            /* Prevent Webkit and Windows Mobile platforms from changing default font sizes, while not breaking desktop design. */
            .ExternalClass {width:100%;} /* Force Hotmail to display emails at full width */
            .ExternalClass, .ExternalClass p, .ExternalClass span, .ExternalClass font, .ExternalClass td, .ExternalClass div {line-height: 100%;} /* Force Hotmail to display normal line spacing. */
            #backgroundTable {margin:0; padding:0; width:100% !important; line-height: 100% !important;}
            img {outline:none; text-decoration:none;border:none; -ms-interpolation-mode: bicubic;}
            a img {border:none;}
            .image_fix {display:block;}
            p {margin: 0px 0px !important;}
            table td {border-collapse: collapse;}
            table { border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt; }
            a {color: #33b9ff;text-decoration: none;text-decoration:none!important;}
            /*STYLES*/
            table[class=full] { width: 100%; clear: both; }
            /*IPAD STYLES*/
            @media only screen and (max-width: 640px) {
            a[href^="tel"], a[href^="sms"] {
            text-decoration: none;
            color: #0a8cce; /* or whatever your want */
            pointer-events: none;
            cursor: default;
            }
            .mobile_link a[href^="tel"], .mobile_link a[href^="sms"] {
            text-decoration: default;
            color: #0a8cce !important;
            pointer-events: auto;
            cursor: default;
            }
            table[class=devicewidth] {width: 440px!important;text-align:center!important;}
            table[class=devicewidthmob] {width: 420px!important;text-align:center!important;}
            table[class=devicewidthinner] {width: 420px!important;text-align:center!important;}
            img[class=banner] {width: 440px!important;height:157px!important;}
            img[class=col2img] {width: 440px!important;height:330px!important;}
            table[class="cols3inner"] {width: 100px!important;}
            table[class="col3img"] {width: 131px!important;}
            img[class="col3img"] {width: 131px!important;height: 82px!important;}
            table[class="removeMobile"]{width:10px!important;}
            img[class="blog"] {width: 420px!important;height: 162px!important;}
            }

            /*IPHONE STYLES*/
            @media only screen and (max-width: 480px) {
            a[href^="tel"], a[href^="sms"] {
            text-decoration: none;
            color: #0a8cce; /* or whatever your want */
            pointer-events: none;
            cursor: default;
            }
            .mobile_link a[href^="tel"], .mobile_link a[href^="sms"] {
            text-decoration: default;
            color: #0a8cce !important; 
            pointer-events: auto;
            cursor: default;
            }
            table[class=devicewidth] {width: 280px!important;text-align:center!important;}
            table[class=devicewidthmob] {width: 260px!important;text-align:center!important;}
            table[class=devicewidthinner] {width: 260px!important;text-align:center!important;}
            img[class=banner] {width: 280px!important;height:100px!important;}
            img[class=col2img] {width: 280px!important;height:210px!important;}
            table[class="cols3inner"] {width: 260px!important;}
            img[class="col3img"] {width: 280px!important;height: 175px!important;}
            table[class="col3img"] {width: 280px!important;}
            img[class="blog"] {width: 260px!important;height: 100px!important;}
            td[class="padding-top-right15"]{padding:15px 15px 0 0 !important;}
            td[class="padding-right15"]{padding-right:15px !important;}
            }
         </style>
      </head>
      <body>
   <!-- Start of preheader -->
   <table width="100%" bgcolor="#dbdbdb" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="preheader" >
      <tbody>
         <tr>
            <td>
               <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                  <tbody>
                     <tr>
                        <td width="100%">
                           <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                              <tbody>
                                 <!-- Spacing -->
                                 <tr>
                                    <td width="100%" height="10"></td>
                                 </tr>
                                 <!-- Spacing -->
                                 <tr>
                              
                                    <!-- Spacing -->
                                 </tr>
                                 <tr>
                                    <td width="100%" height="10"></td>
                                 </tr>
                                 <!-- Spacing -->
                              </tbody>
                           </table>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </td>
         </tr>
      </tbody>
   </table>
   <!-- End of preheader -->      
   <!-- Start of header -->
   <table width="100%" bgcolor="#d8d8d8" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="header">
      <tbody>
         <tr>
            <td>
               <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                  <tbody>
                     <tr>
                        <td width="100%">
                           <table  width="560" cellpadding="0" cellspacing="0" border="0" align="center" style="border-top-left-radius:5px;border-top-right-radius:5px;background: #004f3b" class="devicewidth">
                              <tbody>
                                 <!-- Spacing -->
                                 <tr>
                                    <td height="10" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
                                 </tr>
                                 <!-- Spacing -->
                                 <tr>
                                    <td>
                                       <!-- logo -->
                                       <table width="194" align="left" border="0" cellpadding="0" cellspacing="0">
                                          <tbody>
                                             <tr>
                                                <td width="20"></td>
                                                <td width="174" height="60" align="left">
                                                   <div class="imgpop">
                                                      <a target="_blank" href="#">
                                                          <img src="https://sys.harvestacademy.ac.ug/assets/demo/halogo.png" alt="" border="0" width="60"  style="display:block; border:none; outline:none; text-decoration:none;">
                                                      </a>
                                                   </div>
                                                </td>
                                             </tr>
                                          </tbody>
                                       </table>
                                       <!-- end of logo -->

                                 
                                    </td>
                                 </tr>
                                 <!-- Spacing -->
                                 <tr>
                                    <td height="10" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
                                 </tr>
                                 <!-- Spacing -->
                              </tbody>
                           </table>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </td>
         </tr>
      </tbody>
   </table>


   <table width="100%" bgcolor="#d8d8d8" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="banner">
      <tbody>
         <tr>
            <td>
               <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                  <tbody>
                     <tr>
                        <td width="100%">
                           <table width="560" align="center" cellspacing="0" cellpadding="0" border="0" class="devicewidth">
                              <tbody>
                                 <tr>
                                    <!-- start of image -->
                                    <td align="center" st-image="banner-image"style="background: #fff">
                                       <table class="full" align="center" width="540" cellpadding="0" cellspacing="0" border="0" style="border-collapse:collapse; mso-table-lspace:0pt; mso-table-rspace:0pt;"> 
                                          <tbody>
                                             <tr> 
                                                <td width="100%" height="30"> &nbsp;</td> 
                                             </tr> 
                                        
                                             <!-- END OF HEADING--> 
                                             <!-- START OF TEXT--> 
                                                  <tr> 

                                                <td class="center" align="center" style="margin: 0; padding: 0 15px 15px 15px; margin:0; text-transform: uppercase; font-family: Helvetica, Arial; font-size: 23px;line-height: 34px; mso-line-height-rule: exactly;"> 
                                                   <span>Harvest Academy Notification</span> 
                                                </td> 
                                             </tr> 
                                             <tr> 
                                                <td class="center" align="center" style="margin: 0; padding:0 10px 0 10px; margin:0; font-size:14px ; color:#333; font-family: Helvetica, Arial, sans-serif; line-height: 20px;mso-line-height-rule: exactly;">
                                                    <span>Dear <strong>Parent</strong><br/>
                                                             A New Notification has been posted by Harvest Academy.<br/>
                                                             To be able to view the unread Notification ,Please Click the button below<br/>                                                          
                                                            <br>
                                                    </span> 
                                                </td> 
                                             </tr> 
                                          
                                             <!-- END OF TEXT--> 
                                             <!-- START OF BUTTON-->
                                             <tr> 
                                                <td align="center" valign="middle" style="padding-top: 10px;"> 
                                                   <table border="0" align="center" cellpadding="0" cellspacing="0"  style="margin: 0;"> 
                                                      <tbody>  
                                                  
                                                          <tr>  
                                                         <td align="center" valign="middle" bgcolor="#ffffff" style="padding: 4px 15px;text-transform: uppercase; color:#666666; font-size:15px ; background:#d1a503;color:#ffffff; font-family: Helvetica, Arial, sans-serif; line-height: 25px; mso-line-height-rule: exactly;margin-bottom:5px">                                                     
                               <a href="http://parent.harvestacademy.ac.ug" style="font-weight: normal; color:#fff; text-decoration:none"> VIEW </a> <br/>
                                                         </td> 
                                                      </tr> 
                                                   </tbody>
                                                </table> 
                                             </td> 
                                          </tr> 
                                      
      
                                       </tbody>
                                    </table>
                                   
                                    </td>
                                 </tr>
                              </tbody>
                           </table>
                           <!-- end of image -->
                        </td>
                     </tr>
                  </tbody>
               </table>
            </td>
         </tr>
      </tbody>
   </table>
   <!-- End of main-banner -->


   <!-- Start of footer -->
   <table width="100%" bgcolor="#d8d8d8" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="footer">
      <tbody>
         <tr>
            <td>
               <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                  <tbody>
                     <tr>
                        <td width="100%">
                           <table bgcolor="#e91b23" width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                              <tbody>
                                 <!-- Spacing -->
                                 <tr>
                                    <td height="10" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
                                 </tr>
                                 <!-- Spacing -->
                                 <tr>
                                    <td>
                                       <!-- logo -->
                                       <table width="194" align="left" border="0" cellpadding="0" cellspacing="0">
                                          <tbody>
                                             <tr>
                                                <td width="20"></td>
                                                <td width="174" height="40" align="left" style="font-family: Helvetica, arial, sans-serif; font-size: 14px; color: #FFF; text-align:left; line-height: 24px;">
                                                   FOLLOW US ON:
                                               
                                                </td>
                                             </tr>
                                          </tbody>
                                       </table>
                                       <!-- end of logo -->
                                       <!-- start of social icons -->
                                       <table width="60" height="40" align="right" vaalign="middle"  border="0" cellpadding="0" cellspacing="0">
                                          <tbody>
                                             <tr>
                                                <td width="22" height="22" align="left">
                                                   <div class="imgpop">
                                                      <a target="_blank" href="https://www.facebook.com/harvestacademyuganda/">
                                                          <img src="http://eamodeling.com/img/facebook.png" alt="" border="0" width="22" height="22" style="display:block; border:none; outline:none; text-decoration:none;">
                                                      </a>
                                                   </div>
                                                </td>
                                                <td align="left" width="10" style="font-size:1px; line-height:1px;">&nbsp;</td>
                                                <td width="22" height="22" align="right">
                                                   <div class="imgpop">
                                                      <a target="_blank" href="#">
                                                          <img src="http://eamodeling.com/img/twitter.png" alt="" border="0" width="22" height="22" style="display:block; border:none; outline:none; text-decoration:none;">
                                                      </a>
                                                   </div>
                                                </td>
                                                <td align="left" width="20" style="font-size:1px; line-height:1px;">&nbsp;</td>
                                             </tr>
                                          </tbody>
                                       </table>
                                       <!-- end of social icons -->
                                    </td>
                                 </tr>
                                 <!-- Spacing -->
                                 <tr>
                                    <td height="10" style="font-size:1px; line-height:1px; mso-line-height-rule: exactly;">&nbsp;</td>
                                 </tr>
                                 <!-- Spacing -->
                              </tbody>
                           </table>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </td>
         </tr>
      </tbody>
   </table>
   <!-- End of footer -->
   <!-- Start of postfooter -->
   <table width="100%" bgcolor="#dbdbdb" cellpadding="0" cellspacing="0" border="0" id="backgroundTable" st-sortable="preheader" >
      <tbody>
         <tr>
            <td>
               <table width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                  <tbody>
                     <tr>
                        <td width="100%">
                           <table bgcolor="#ffffff" width="560" cellpadding="0" cellspacing="0" border="0" align="center" class="devicewidth">
                              <tbody>
                                 <!-- Spacing -->
                                 <tr>
                                    <td width="100%" height="10"></td>
                                 </tr>
                                 <!-- Spacing -->
                                 <tr>
                                    <td align="center" valign="middle" style="font-family: Helvetica, arial, sans-serif; font-size: 13px;color: #7a6e67;text-align:center;" st-content="viewonline">
                                      All rights reserved to Harvest Academy
                                  
                                    </td>
                                 </tr>
                                    <!-- Spacing -->
                                 <tr>
                                    <td width="100%" height="10"></td>
                                 </tr>
                                 <!-- Spacing -->
                              </tbody>
                           </table>
                        </td>
                     </tr>
                  </tbody>
               </table>
            </td>
         </tr>
      </tbody>
   </table>
   EOT;

                       $header = "From:Harvest Academy <info@harvestacademy.ac.ug> \r\n";
                       $header .= "MIME-Version: 1.0\r\n";
                       $header .= "Content-type: text/html\r\n";
                       $header .= 'BCC: ' . $to . "\r\n";
                       $retval = mail(null, $subject, $message, $header, '-finfo@harvestacademy.ac.ug');
                       if ($retval == FALSE) {
                           echo "<div class='alert alert-danger'>Error!! Email Not Sent</div>";
                       } else {
                           echo '<div class="alert alert-success">Notification  Successfully Posted</div>';
                       }
                   }
               }

               ?>
                                 <!-- Spacing -->
                              <tr>
                                 <td width="100%" height="10"></td>
                              </tr>
                              <!-- Spacing -->
                           </tbody>
                        </table>
                     </td>
                  </tr>
               </tbody>
            </table>
         </td>
      </tr>
   </tbody>
</table>';
                 
         $header = "From:Harvest Academy <info@harvestacademy.ac.ug> \r\n";
         $header .= "MIME-Version: 1.0\r\n";
         $header .= "Content-type: text/html\r\n";
         $header .= 'BCC: '.$to. "\r\n";     
     $retval = mail (null,$subject,$message,$header,'-finfo@harvestacademy.ac.ug');       
       if( $retval == FALSE )
       {
         echo "<div class='alert alert-danger'>Error!! Email Not Sent</div>";
       }  else {                                                 
               echo '<div class="alert alert-success">Notification  Successfully Posted</div>';                   
                            }                                      
                                }
                                }

                                      ?>


 <form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
      
                                  <div class="hr-line-dashed"></div>
                                   <div class="form-group">
                                            <label class="control-label">Reply</label>
                                                     <textarea class="ckeditor" cols="80" id="editor1" name="notification" rows="100">                                            
                                                </textarea>
                                                                                                                        </div>
                                                                                     
                                   
                                <div class="form-group">                                                                
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                                              </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>
     <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js?v=1.0.5"></script>
    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>
 <script>
    
      $('#reciever').on('change', function() {
               var getselect=$(this).val();
                 if(getselect===''){                 
         $('.classes').hide();
         $('.parents').hide();
                    }
  if(getselect==='class'){
         $('.classes').show();
         $('.parents').hide();
              }
        if(getselect==='single'){
          $('.classes').hide();
         $('.parents').show();        
               }
           });
           </script>
</body>

</html>
 