<?php
include '../includes/conn.php';
    if(!isset($_SESSION['teachersys']) || ($_SESSION['classteacher'] !== 'yes')){
         header('Location:login.php');
         exit;
    }
    // ensure class_id is an integer if present in session
    $session_class_id = isset($_SESSION['class_id']) ? (int)$_SESSION['class_id'] : 0;
?>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Prime Areas | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <!-- Data Tables -->
    <link href="<?php echo BASE_URL; ?>/css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>

<body>

    <div id="wrapper">

        
        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
         
        </div>
            <ul class="nav navbar-top-links navbar-right">
             
              
                                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Grade Prime Areas</h2>
                    <ol class="breadcrumb">
                         <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                       
                         <li>
                            <a>Subjects</a>
                        </li>
                        <li class="active">
                            <strong>View Prime Areas</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content animated fadeInRight">
            <div class="row">
              
               
                <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>All Prime Areas<small>Sort, search</small></h5>                       
                    </div>
                    <div class="ibox-content">
<?php
// Fetch prime subjects for this teacher's class (use JOINs to avoid per-row queries)
if ($session_class_id > 0) {
    $sql = "SELECT s.subject_id, s.subject, s.creator, s.class_id, c.class AS class_name, t.fullname AS teacher_name
            FROM subjects s
            LEFT JOIN classes c ON s.class_id = c.class_id
            LEFT JOIN teachers t ON s.creator = t.teacher_id
            WHERE s.status = 1 AND s.type = 'prime' AND s.class_id = ?";
    $stmt = mysqli_prepare($con, $sql);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'i', $session_class_id);
        mysqli_stmt_execute($stmt);
        $subjects = mysqli_stmt_get_result($stmt);
    } else {
        $subjects = null;
    }
} else {
    // fallback: no class filter
    $sql = "SELECT s.subject_id, s.subject, s.creator, s.class_id, c.class AS class_name, t.fullname AS teacher_name
            FROM subjects s
            LEFT JOIN classes c ON s.class_id = c.class_id
            LEFT JOIN teachers t ON s.creator = t.teacher_id
            WHERE s.status = 1 AND s.type = 'prime'";
    $stmt = mysqli_prepare($con, $sql);
    if ($stmt) {
        mysqli_stmt_execute($stmt);
        $subjects = mysqli_stmt_get_result($stmt);
    } else {
        $subjects = null;
    }
}
if (!empty($subjects) && mysqli_num_rows($subjects) > 0) {
 
 ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                    <thead>
                    <tr>
                            <th>Subject</th>
                        <th>Class</th>
                            <th>Added By</th>
                               <th>Action</th>
                                                          </tr>
                    </thead>
                    <tbody>
                            <?php
                             while($row = mysqli_fetch_assoc($subjects)){
                                    $subject_id = isset($row['subject_id']) ? (int)$row['subject_id'] : 0;
                                    $subject = $row['subject'] ?? '';
                                    $creator = isset($row['creator']) ? (int)$row['creator'] : 0;
                                    $class = $row['class_name'] ?? '';
                                    $fullname = $row['teacher_name'] ?? '';
                                    // only show rows for the session class (maintain original behavior)
                                    if ($session_class_id > 0 && $row['class_id'] != $session_class_id) continue;
                            ?>
                                        <tr class="gradeA">
                                                                            <td><?php echo htmlspecialchars($subject, ENT_QUOTES); ?></td>
                                                 <td class="center">
                                                                                 <?php echo htmlspecialchars($class, ENT_QUOTES); ?>
                                                </td>
                        
                                             <td> <div class="tooltip-demo">
                                                                                         <?php echo htmlspecialchars($fullname, ENT_QUOTES); ?>
                                             </div></td>
              
    <td class="center"> 
                    <a href="subjectdetails?id=<?php echo rawurlencode((string)$subject_id); ?>"  class="btn btn-info  btn-xs">Details <i class="fa fa-folder-open"></i></a>
                                    <a href="editsubject?id=<?php echo rawurlencode((string)$subject_id); ?>"  class="btn btn-primary  btn-xs">Edit <i class="fa fa-edit"></i></a>
                                <a href="hidesubject?id=<?php echo rawurlencode((string)$subject_id); ?>"  class="btn btn-danger  btn-xs" onclick="return confirm('You are about To Remove this item. Are you sure you want to proceed?')">Remove <i class="fa fa-trash"></i></a>   
    </td>
                                        </tr>
                             <?php }
                             if ($stmt) mysqli_stmt_close($stmt);
                             ?>
                    </tbody>
                                    </table>
 <?php }?>
                    </div>
                </div>
            </div>
            </div>
          
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <script src="<?php echo BASE_URL; ?>/js/plugins/jeditable/jquery.jeditable.js"></script>

    <!-- Data Tables -->
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/dataTables/dataTables.bootstrap.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>

    <!-- Page-Level Scripts -->
    <script>
        $(document).ready(function() {
            $('.dataTables-example').dataTable();

            /* Init DataTables */
            var oTable = $('#editable').dataTable();

            /* Apply the jEditable handlers to the table */
            oTable.$('td').editable( 'http://webapplayers.com/example_ajax.php', {
                "callback": function( sValue, y ) {
                    var aPos = oTable.fnGetPosition( this );
                    oTable.fnUpdate( sValue, aPos[0], aPos[1] );
                },
                "submitdata": function ( value, settings ) {
                    return {
                        "row_id": this.parentNode.getAttribute('id'),
                        "column": oTable.fnGetPosition( this )[2]
                    };
                },

                "width": "90%"
            } );


        });

        function fnClickAddRow() {
            $('#editable').dataTable().fnAddData( [
                "Custom row",
                "New row",
                "New row",
                "New row",
                "New row" ] );

        }
    </script>
</body>
</html>