<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location: login.php');
    exit;
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>View Marks-School Manager</title>
 <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />
 <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/css/datepicker-custom.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/css/timepicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-colorpicker/css/colorpicker.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker-bs3.css" />
  <link rel="stylesheet" type="text/css" href="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/css/datetimepicker-custom.css" />
  <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" rel="stylesheet">
  <!--common-->

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
        <!--<link id="beyond-link" href="<?php echo BASE_URL; ?>/js/fullcalendar/beyond.min.css" rel="stylesheet" />-->
     
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>

<body class="sticky-header">
<section>
   <?php include 'nav.php'; ?>

        <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
                 Assessment Details
                    </header>
                             <div class="panel-body">  
                           <?php
                                 // validate GET params
                                 $class_id = filter_input(INPUT_GET, 'cl', FILTER_VALIDATE_INT);
                                 $subject = filter_input(INPUT_GET, 'sub', FILTER_VALIDATE_INT);
                                 $as = filter_input(INPUT_GET, 'as', FILTER_VALIDATE_INT);
                                 $date = filter_input(INPUT_GET, 'dt', FILTER_VALIDATE_INT);
                                 $term = filter_input(INPUT_GET, 'tm', FILTER_VALIDATE_INT);
                                 $paper = filter_input(INPUT_GET, 'pap', FILTER_VALIDATE_INT);

                                 if (!$class_id || !$subject || !$as || !$date || !$term) {
                                       echo '<div class="alert alert-danger">Invalid request parameters.</div>';
                                       // stop rendering further
                                 } else {
                                    // fetch class
                                    $class2 = '';
                                    $category_id = 0;
                                    $reporttype = 0;
                                    $cstmt = mysqli_prepare($con, "SELECT class, category_id, report_type FROM classes WHERE class_id = ? LIMIT 1");
                                    if ($cstmt) {
                                       mysqli_stmt_bind_param($cstmt, 'i', $class_id);
                                       mysqli_stmt_execute($cstmt);
                                       $cres = mysqli_stmt_get_result($cstmt);
                                       if ($cres && mysqli_num_rows($cres) > 0) {
                                          $crow = mysqli_fetch_assoc($cres);
                                          $class2 = $crow['class'] ?? '';
                                          $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
                                          $reporttype = isset($crow['report_type']) ? (int)$crow['report_type'] : 0;
                                       }
                                       mysqli_stmt_close($cstmt);
                                    }

                                    // fetch subject
                                    $subject2 = '';
                                    $sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
                                    if ($sstmt) {
                                       mysqli_stmt_bind_param($sstmt, 'i', $subject);
                                       mysqli_stmt_execute($sstmt);
                                       $sres = mysqli_stmt_get_result($sstmt);
                                       if ($sres && mysqli_num_rows($sres) > 0) {
                                          $srow = mysqli_fetch_assoc($sres);
                                          $subject2 = $srow['subject'] ?? '';
                                       }
                                       mysqli_stmt_close($sstmt);
                                    }

                                    // fetch term
                                    $term2 = '';
                                    $year = '';
                                    $tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
                                    if ($tstmt) {
                                       mysqli_stmt_bind_param($tstmt, 'i', $term);
                                       mysqli_stmt_execute($tstmt);
                                       $tres = mysqli_stmt_get_result($tstmt);
                                       if ($tres && mysqli_num_rows($tres) > 0) {
                                          $trow = mysqli_fetch_assoc($tres);
                                          $term2 = $trow['term'] ?? '';
                                          $year = $trow['year'] ?? '';
                                       }
                                       mysqli_stmt_close($tstmt);
                                    }

                                    // fetch paper name if any
                                    $paper2 = 'No Paper';
                                    if ($paper && $paper != 0) {
                                       $pstmt = mysqli_prepare($con, "SELECT paper_name FROM papers WHERE paper_id = ? LIMIT 1");
                                       if ($pstmt) {
                                          mysqli_stmt_bind_param($pstmt, 'i', $paper);
                                          mysqli_stmt_execute($pstmt);
                                          $pres = mysqli_stmt_get_result($pstmt);
                                          if ($pres && mysqli_num_rows($pres) > 0) {
                                             $prow = mysqli_fetch_assoc($pres);
                                             $paper2 = $prow['paper_name'] ?? 'No Paper';
                                          }
                                          mysqli_stmt_close($pstmt);
                                       }
                                    }

                                    // fetch assessment type
                                    $assessment = '';
                                    $atypes = mysqli_prepare($con, "SELECT assessmenttype FROM assessmenttypes WHERE assessmenttype_id = ? LIMIT 1");
                                    if ($atypes) {
                                       mysqli_stmt_bind_param($atypes, 'i', $as);
                                       mysqli_stmt_execute($atypes);
                                       $atres = mysqli_stmt_get_result($atypes);
                                       if ($atres && mysqli_num_rows($atres) > 0) {
                                          $arow = mysqli_fetch_assoc($atres);
                                          $assessment = $arow['assessmenttype'] ?? '';
                                       }
                                       mysqli_stmt_close($atypes);
                                    }
                                 }
                                ?>
                                <table  class="display table  table-striped" id="dynamic-table">
             <tbody>
         
                <tr class="gradeA">
                       <th>Assessment</th>
                       <td><?php echo $assessment;?></td>
                  </tr>
                 <tr class="gradeA">
                       <th>Class</th>
                       <td><?php echo $class2;?></td>
                  </tr>
                  <tr class="gradeA">
                             <th>Subject</th>
            <td><?php echo $subject2; ?></td>
            </tr>
            <?php if ($reporttype != 1) { ?>
            <tr class="gradeA">
                             <th>Paper</th>
            <td><?php echo $paper2; ?></td>
            </tr>
            <?php } ?>
                           <tr class="gradeA">
                             <th> Term</th>
                             <td><?php echo $term2.' '.$year;?></td>
            </tr>
                 <tr class="gradeA">
                             <th> Date</th>
                             <td><?php echo date('d/M/Y',$date);?></td>
            </tr>
                   </tbody>
                        </table>
                                      
                           
              </div>
                          </section>
                    </div>
                <div class="col-lg-10">
                      <section class="panel">
                    <header class="panel-heading">
                  Student Marks
                    </header>
                                        <div class="panel-body"> 
                            <?php
                              if (isset($class_id, $subject, $as, $term, $date)) {
                                 if ($paper && $paper != 0) {
                                    $mstmt = mysqli_prepare($con, "SELECT mark_id, marks, student_id, status, rank, effort_id FROM marks WHERE class_id = ? AND subject_id = ? AND assessment = ? AND term_id = ? AND date = ? AND paper_id = ? AND status = 1");
                                    if ($mstmt) mysqli_stmt_bind_param($mstmt, 'iiiiii', $class_id, $subject, $as, $term, $date, $paper);
                                 } else {
                                    $mstmt = mysqli_prepare($con, "SELECT mark_id, marks, student_id, status, rank, effort_id FROM marks WHERE class_id = ? AND subject_id = ? AND assessment = ? AND term_id = ? AND date = ? AND status = 1");
                                    if ($mstmt) mysqli_stmt_bind_param($mstmt, 'iiiii', $class_id, $subject, $as, $term, $date);
                                 }
                                 $marks = null;
                                 if ($mstmt) {
                                    mysqli_stmt_execute($mstmt);
                                    $marks = mysqli_stmt_get_result($mstmt);
                                 }

                              }
                              if (!empty($marks) && mysqli_num_rows($marks) > 0) {
   ?>
                    <table class="table table-striped table-bordered table-hover dataTables-example" >
                    <thead>
                    <tr>
                        <th>Student</th>
                                    <th>Marks</th>
                                    <!-- <th>Effort</th>
                                    <th>Comment</th> -->
                            <th>Action</th>
                    </tr>
                    </thead>
           <tbody>
        <?php
      // prepare student stmt once
      $studentStmt = mysqli_prepare($con, "SELECT fullname FROM students WHERE student_id = ? LIMIT 1");
         while($row = mysqli_fetch_assoc($marks)){
            $mark_id = isset($row['mark_id']) ? (int)$row['mark_id'] : 0;
            $mark = $row['marks'] ?? '';
            $student_id = isset($row['student_id']) ? (int)$row['student_id'] : 0;
            $status = $row['status'] ?? '';
            $rank = $row['rank'] ?? '';
            $effort = $row['effort_id'] ?? 0;
          ?>
               
                    <tr class="gradeA">
                    <td><?php
                   $fullname = '';
                   if ($studentStmt) {
                      mysqli_stmt_bind_param($studentStmt, 'i', $student_id);
                      mysqli_stmt_execute($studentStmt);
                      $sres = mysqli_stmt_get_result($studentStmt);
                      if ($sres && mysqli_num_rows($sres) > 0) {
                         $srow = mysqli_fetch_assoc($sres);
                         $fullname = $srow['fullname'] ?? '';
                      }
                   }
                  echo htmlspecialchars($fullname, ENT_QUOTES);
                  ?></td>
                      <td><?php
                  echo htmlspecialchars($mark . '/' . $rank, ENT_QUOTES); ?></td>
                        <!-- <td><?php
                         if (($effort == 0)||($effort == "")) {
                           echo "No Effort";
                           }else{
                              $geteffort=  mysqli_query($con,"SELECT * FROM effort_types WHERE effort_id='$effort'");
                                          $row3=  mysqli_fetch_array($geteffort);
                                          $effort2=$row3['description'];
                                          $effort_rant = $row3['rank'];
                                          echo 'Rank ('.$effort_rant.'): '. $effort2;
                              } ?></td> -->
                          
                    
   <td class="center"> 
       
                         <a href="editmark?id=<?php echo htmlspecialchars($mark_id, ENT_QUOTES); ?>" target="_blank"  class="btn btn-info btn-xs"><i class="fa fa-edit"></i> Edit</a>
                               
   </td>
                    </tr>
                         <?php }
                         if ($studentStmt) mysqli_stmt_close($studentStmt);
                         if (isset($mstmt) && $mstmt) mysqli_stmt_close($mstmt);
                         ?>
                    </tbody>
                                    </table>
 <?php }  else { ?>
                        <div class="alert alert-danger">Oops!! No Marks Added Yet</div>
<?php }  ?>
                     
                                      
                           
              </div>
              </section>
                          </div>  
                         
                       </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>
      <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-datetimepicker/js/bootstrap-datetimepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/moment.min.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-daterangepicker/daterangepicker.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/bootstrap-timepicker/js/bootstrap-timepicker.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
<script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
 <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>
  
</body>

</html>
 