<?php
include '../includes/conn.php';

// Ensure session is active
if (session_status() === PHP_SESSION_NONE) {
	session_start();
}

// Clear session data
$_SESSION = [];

// If a session cookie exists, remove it
$params = session_get_cookie_params();
setcookie(session_name(), '', time() - 42000,
	$params['path'] ?? '/',
	$params['domain'] ?? '',
	$params['secure'] ?? false,
	$params['httponly'] ?? true
);

// Destroy the session
session_destroy();

// Redirect to login (explicit filename)
header('Location: login.php');
exit;
?>