<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location: login.php');
  exit;
}

// Validate GET params
$classParam = filter_input(INPUT_GET, 'class', FILTER_SANITIZE_STRING);
$term = filter_input(INPUT_GET, 'term', FILTER_VALIDATE_INT);
if (empty($classParam) || !$term) {
  header('Location: index.php');
  exit;
}

$split = explode(',', $classParam);
$class_id = isset($split[0]) ? (int)$split[0] : 0;
$subject_id = isset($split[1]) ? (int)$split[1] : 0;

// fetch class info
$class = '';
$reportype = 0;
$category_id = 0;
$cstmt = mysqli_prepare($con, "SELECT `class`, report_type, category_id FROM classes WHERE class_id = ? LIMIT 1");
if ($cstmt) {
  mysqli_stmt_bind_param($cstmt, 'i', $class_id);
  mysqli_stmt_execute($cstmt);
  $cres = mysqli_stmt_get_result($cstmt);
  if ($cres && mysqli_num_rows($cres) > 0) {
    $crow = mysqli_fetch_assoc($cres);
    $class = $crow['class'] ?? '';
    $reportype = isset($crow['report_type']) ? (int)$crow['report_type'] : 0;
    $category_id = isset($crow['category_id']) ? (int)$crow['category_id'] : 0;
  }
  mysqli_stmt_close($cstmt);
}

// fetch subject name
$subject = '';
$sstmt = mysqli_prepare($con, "SELECT subject FROM subjects WHERE subject_id = ? LIMIT 1");
if ($sstmt) {
  mysqli_stmt_bind_param($sstmt, 'i', $subject_id);
  mysqli_stmt_execute($sstmt);
  $sres = mysqli_stmt_get_result($sstmt);
  if ($sres && mysqli_num_rows($sres) > 0) {
    $srow = mysqli_fetch_assoc($sres);
    $subject = $srow['subject'] ?? '';
  }
  mysqli_stmt_close($sstmt);
}

// fetch term
$term2 = '';
$year = '';
$tstmt = mysqli_prepare($con, "SELECT term, year FROM financialterms WHERE financialterm_id = ? LIMIT 1");
if ($tstmt) {
  mysqli_stmt_bind_param($tstmt, 'i', $term);
  mysqli_stmt_execute($tstmt);
  $tres = mysqli_stmt_get_result($tstmt);
  if ($tres && mysqli_num_rows($tres) > 0) {
    $trow = mysqli_fetch_assoc($tres);
    $term2 = $trow['term'] ?? '';
    $year = $trow['year'] ?? '';
  }
  mysqli_stmt_close($tstmt);
}
                                  
   ?>
<html>
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title><?php echo $subject.' : '.$class.' Assessment Results for Term '.$term2.' '.$year; ?> | School Manager</title>

    <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
</head>

<body>
<section>
   <?php include 'nav.php'; ?>

     <section class="wrapper">
        <!-- page start-->

        <div class="row">
        
    <div class="col-lg-8">
    <?php 
    if (isset($_POST['updatesubmit'])) {
      $papers = filter_input(INPUT_POST, 'papers', FILTER_VALIDATE_INT);
      $classs_id = filter_input(INPUT_POST, 'std', FILTER_VALIDATE_INT);
      $subjects_id = filter_input(INPUT_POST, 'subject_id', FILTER_VALIDATE_INT);
      $terms = filter_input(INPUT_POST, 'term', FILTER_VALIDATE_INT);
      $mark = filter_input(INPUT_POST, 'mark_id', FILTER_VALIDATE_INT);

      if (empty($papers) || !$classs_id || !$subjects_id || !$terms || !$mark) {
        echo '<div class="alert alert-danger">Please Select Paper Name and ensure form fields are valid</div>';
      } else {
        // fetch existing mark date
        $mstmt = mysqli_prepare($con, "SELECT date FROM marks WHERE mark_id = ? LIMIT 1");
        if ($mstmt) {
            mysqli_stmt_bind_param($mstmt, 'i', $mark);
            mysqli_stmt_execute($mstmt);
            $mres = mysqli_stmt_get_result($mstmt);
            if ($mres && mysqli_num_rows($mres) > 0) {
                $mrow = mysqli_fetch_assoc($mres);
                $date = $mrow['date'];

                $ustmt = mysqli_prepare($con, "UPDATE marks SET paper_id = ? WHERE class_id = ? AND subject_id = ? AND term_id = ? AND date = ?");
                if ($ustmt) {
                    mysqli_stmt_bind_param($ustmt, 'iiiii', $papers, $classs_id, $subjects_id, $terms, $date);
                    mysqli_stmt_execute($ustmt);
                    if (mysqli_stmt_affected_rows($ustmt) >= 0) {
                        echo '<div class="alert alert-success">Paper Updated Successfully</div>';
                    }
                    mysqli_stmt_close($ustmt);
                }
            }
            mysqli_stmt_close($mstmt);
        }
      }
    }


?>
   
                      <section class="panel">
                                    <?php
                                          $ass_stmt = mysqli_prepare($con, "SELECT mark_id, date, assessment, paper_id FROM marks WHERE subject_id = ? AND class_id = ? AND term_id = ? AND status = 1 GROUP BY assessment, paper_id ORDER BY date");
                                          if ($ass_stmt) {
                                            mysqli_stmt_bind_param($ass_stmt, 'iii', $subject_id, $class_id, $term);
                                            mysqli_stmt_execute($ass_stmt);
                                            $ass_res = mysqli_stmt_get_result($ass_stmt);
                                            while ($markRow = mysqli_fetch_assoc($ass_res)) {
                                              $id = isset($markRow['mark_id']) ? (int)$markRow['mark_id'] : 0;
                                              $date = isset($markRow['date']) ? (int)$markRow['date'] : 0;
                                              $as = isset($markRow['assessment']) ? (int)$markRow['assessment'] : 0;
                                              $paper = isset($markRow['paper_id']) ? (int)$markRow['paper_id'] : 0;

                                              $paper_name = 'No Paper';
                                              $paper_id = 0;
                                              if ($paper != 0) {
                                                $pstmt = mysqli_prepare($con, "SELECT paper_id, paper_name FROM papers WHERE paper_id = ? LIMIT 1");
                                                if ($pstmt) {
                                                  mysqli_stmt_bind_param($pstmt, 'i', $paper);
                                                  mysqli_stmt_execute($pstmt);
                                                  $pres = mysqli_stmt_get_result($pstmt);
                                                  if ($pres && mysqli_num_rows($pres) > 0) {
                                                    $prow = mysqli_fetch_assoc($pres);
                                                    $paper_id = isset($prow['paper_id']) ? (int)$prow['paper_id'] : 0;
                                                    $paper_name = $prow['paper_name'] ?? 'No Paper';
                                                  }
                                                  mysqli_stmt_close($pstmt);
                                                }
                                              }

                                              $atype = '';
                                              $type_id = 0;
                                              $tstmt2 = mysqli_prepare($con, "SELECT assessmenttype_id, assessmenttype FROM assessmenttypes WHERE assessmenttype_id = ? LIMIT 1");
                                              if ($tstmt2) {
                                                mysqli_stmt_bind_param($tstmt2, 'i', $as);
                                                mysqli_stmt_execute($tstmt2);
                                                $tres2 = mysqli_stmt_get_result($tstmt2);
                                                if ($tres2 && mysqli_num_rows($tres2) > 0) {
                                                  $trow2 = mysqli_fetch_assoc($tres2);
                                                  $type_id = isset($trow2['assessmenttype_id']) ? (int)$trow2['assessmenttype_id'] : 0;
                                                  $atype = $trow2['assessmenttype'] ?? '';
                                                }
                                                mysqli_stmt_close($tstmt2);
                                              }
                                                ?>               
                                         <tr class="gradeA">    
                                                    <td><?php echo date('d/M/Y', $date); ?></td>
                                                       <td><?php echo htmlspecialchars($atype, ENT_QUOTES); ?></td>  
                                                      <?php if ($reportype != 1) { ?>
                                                       <td><?php echo htmlspecialchars($paper_name, ENT_QUOTES); ?></td>  
                                                      <?php } ?>
                                                       <td>
                                                      <?php if ($paper_name == 'No Paper') { ?>

                                                                             <a href="marks?cl=<?php echo $class_id; ?>&&sub=<?php echo $subject_id;?>&&as=<?php echo $as; ?>&&dt=<?php echo $date;?>&&tm=<?php echo $term;?>&&pap=0" class="btn btn-success btn-xs">View Results</a>
                                                                              <?php } else { ?>
                                                                              <a href="marks?cl=<?php echo $class_id; ?>&&sub=<?php echo $subject_id;?>&&as=<?php echo $as; ?>&&dt=<?php echo $date;?>&&tm=<?php echo $term;?>&&pap=<?php echo $paper_id; ?> " class="btn btn-success btn-xs">View Results</a>
                                                                              <?php } ?>
                                                                              <?php if ($reportype != 1) { ?>
                                                                             <a data-toggle="modal" href="#modal-form<?php echo $id; ?>" class="btn btn-xs btn-success"><i class="fa fa-edit"></i> Edit Paper </a>
                                                                              <?php } ?>
                                                                             <a href="removeresults?cl=<?php echo $class_id; ?>&&sub=<?php echo $subject_id;?>&&dt=<?php echo $date;?>&&tm=<?php echo $term;?>" class="btn btn-danger btn-xs" onclick="return confirm_delete<?php echo $id;?>()"> Remove Results </a>
                                                  
                                                                          </td>
                                                  </tr>
                                                   <script type="text/javascript">
                              function confirm_delete<?php echo $id; ?>() {
                                return confirm('You are about To Remove this Class Results. Are you sure you want to proceed?');
                              }
                              </script>             
                              <div id="modal-form<?php echo $id; ?>" class="modal fade" aria-hidden="true">
                                              <div class="modal-dialog">
                                                <div class="modal-content">
                                                  <div class="modal-body">
                                                    <div class="row">
                                                      <div class="col-sm-12">
                                                        <h3 class="m-t-none m-b">Edit  <?php echo htmlspecialchars($paper_name, ENT_QUOTES); ?></h3>
                                                        <form role="form" method="POST" action="" enctype="multipart/form-data">
                                                        <input  type="hidden" value="<?php echo $class_id;?>" name="std" >
                                                        <input  type="hidden" value="<?php echo $subject_id;?>" name="subject_id" >
                                                        <input  type="hidden" value="<?php echo $term;?>" name="term" >
                                                        <input  type="hidden" value="<?php echo $id;?>" name="mark_id" >
                                                    
                                                            <div class="form-group">
                                                                <label for="username" class="control-label">Paper Name</label>
                                                                <select name="papers" class="form-control" >
                                                                                  <?php 
                                                        $paperStmt = mysqli_prepare($con, "SELECT paper_id, paper_name FROM papers WHERE status = 1");
                                                        if ($paperStmt) {
                                                          mysqli_stmt_execute($paperStmt);
                                                          $paperRes = mysqli_stmt_get_result($paperStmt);
                                                          while ($prow = mysqli_fetch_assoc($paperRes)) {
                                                            $paper_id = isset($prow['paper_id']) ? (int)$prow['paper_id'] : 0;
                                                            $paper_name = $prow['paper_name'] ?? '';
                                                         ?>
                                                         <option value="<?php echo $paper_id; ?>"><?php   echo htmlspecialchars($paper_name, ENT_QUOTES); ?></option>
                                                <?php }
                                                        mysqli_stmt_close($paperStmt);
                                                        }
                                                        ?>
                                                   </select>
                                                            </div>
                                                            <button class="btn btn-sm btn-primary pull-right m-t-n-xs" type="submit" name="updatesubmit"><strong>Update</strong></button>
                                                        </form>
                                                      </div>
                                                
                                                  </div>
                                                </div>
                                                </div>
                                              </div>
                                    </div>
                                                <?php }
                                            mysqli_stmt_close($ass_stmt);
                                          }
                                        ?>
                    </tbody>
                                    </table>

                       </div>
                             </section>
                          </div>
   
        </div>
    
        </section>
    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
   <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL; ?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL; ?>/js/dynamic_table_init.js"></script>
<!--common scripts for all pages-->
<script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
</body>

</html>