<?php
include '../includes/conn.php';

// session guard
if (!isset($_SESSION['teachersys'])) {
    header('Location: ../login.php');
    exit;
}

// validate POST input
$type = filter_input(INPUT_POST, 'type', FILTER_SANITIZE_STRING) ?: '';
if ($type !== 'fetch') {
    // nothing to do
    exit;
}

header('Content-Type: application/json; charset=utf-8');

$events = [];

// prepared select (no external params but prepare for consistency)
$stmt = mysqli_prepare($con, "SELECT event_id, eventname, description, startdate, enddate FROM events WHERE status = 1");
if ($stmt) {
    mysqli_stmt_execute($stmt);
    $res = mysqli_stmt_get_result($stmt);
    while ($row = mysqli_fetch_assoc($res)) {
        $e = [];
        $startdate = isset($row['startdate']) ? (int)$row['startdate'] : 0;
        $enddate = isset($row['enddate']) ? (int)$row['enddate'] : $startdate;
        $eventname = $row['eventname'] ?? '';
        $event_id = isset($row['event_id']) ? (int)$row['event_id'] : 0;
        $description = $row['description'] ?? '';

        $getsdate = date('Y-m-d', $startdate);
        if ($enddate == $startdate) {
            $getedate = date('Y-m-d', $enddate);
        } else {
            $enddate2 = $enddate + (3600 * 24);
            $getedate = date('Y-m-d', $enddate2);
        }

        $e['url'] = 'event?id=' . $event_id;
        $e['id'] = $event_id;
        $e['title'] = $eventname;
        $e['start'] = $getsdate . 'T00:01:00+05:30';
        $e['end'] = $getedate . 'T00:01:00+05:30';
        $e['allDay'] = false;

        $events[] = $e;
    }
    mysqli_stmt_close($stmt);
}

echo json_encode($events);
?>