<?php
include '../includes/conn.php';
    if(!isset($_SESSION['teachersys'])){
header('Location:login.php');
  exit;
    }
  $id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
  if (!$id) {
     header('Location:notifications.php');
     exit;
  }
 ?>
<!DOCTYPE html>
<html>


<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Notification  | School  Manager</title>

    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">

    <link href="<?php echo BASE_URL; ?>/css/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">

</head>
<body>

    <div id="wrapper">

        <?php include 'nav.php'; ?>
        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top  " role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
        
        </div>
            <ul class="nav navbar-top-links navbar-right">
            
            
                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
<div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-9">
                    <h2>Notification Details</h2>
                 
                </div>
                           </div>
            <div class="wrapper wrapper-content animated fadeInRight">
                                <?php
            // Fetch notification with prepared statement
            $getnotification_stmt = mysqli_prepare($con, "SELECT * FROM notifications WHERE notification_id = ? LIMIT 1");
            mysqli_stmt_bind_param($getnotification_stmt, 'i', $id);
            mysqli_stmt_execute($getnotification_stmt);
            $res = mysqli_stmt_get_result($getnotification_stmt);
            if ($res && mysqli_num_rows($res) > 0) {
                $row = mysqli_fetch_assoc($res);
                $notification_id = (int)($row['notification_id'] ?? 0);
                $sender = (int)($row['sender'] ?? 0);
                $reciever = $row['reciever'] ?? '';
                $sendertype = $row['sendertype'] ?? '';
                $messagetype = $row['messagetype'] ?? '';
                $notification = strip_tags($row['notification'] ?? '');
                $timestamp = (int)($row['timestamp'] ?? 0);

                $to = '';
                if ($messagetype === 'all') {
                    $to = 'All Parents';
                } elseif ($messagetype === 'class') {
                    $stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
                    mysqli_stmt_bind_param($stmt, 'i', $reciever);
                    mysqli_stmt_execute($stmt);
                    $r = mysqli_stmt_get_result($stmt);
                    if ($r && $rowc = mysqli_fetch_assoc($r)) {
                        $to = $rowc['class'] ?? '';
                    }
                    if ($stmt) mysqli_stmt_close($stmt);
                } elseif ($messagetype === 'single') {
                    $stmt = mysqli_prepare($con, "SELECT parent_name FROM parents WHERE parent_id = ? LIMIT 1");
                    mysqli_stmt_bind_param($stmt, 'i', $reciever);
                    mysqli_stmt_execute($stmt);
                    $r = mysqli_stmt_get_result($stmt);
                    if ($r && $rowp = mysqli_fetch_assoc($r)) {
                        $to = $rowp['parent_name'] ?? '';
                    }
                    if ($stmt) mysqli_stmt_close($stmt);
                } elseif ($messagetype === 'section') {
                    $stmt = mysqli_prepare($con, "SELECT classcategory FROM classcategories WHERE classcategory_id = ? LIMIT 1");
                    mysqli_stmt_bind_param($stmt, 'i', $reciever);
                    mysqli_stmt_execute($stmt);
                    $r = mysqli_stmt_get_result($stmt);
                    if ($r && $rowsc = mysqli_fetch_assoc($r)) {
                        $to = $rowsc['classcategory'] ?? '';
                    }
                    if ($stmt) mysqli_stmt_close($stmt);
                }
            ?>
      <div class="row">
               <div class="col-md-3">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                                         <?php 
                                         $fullname = '';
                                         $ext = '';
                                         $designation = '';
                                         if ($sendertype === 'Teachers') {
                                             $stmt = mysqli_prepare($con, "SELECT fullname, ext, designation FROM teachers WHERE teacher_id = ? LIMIT 1");
                                             mysqli_stmt_bind_param($stmt, 'i', $sender);
                                             mysqli_stmt_execute($stmt);
                                             $r = mysqli_stmt_get_result($stmt);
                                             if ($r && $rw = mysqli_fetch_assoc($r)) {
                                                 $fullname = $rw['fullname'] ?? '';
                                                 $ext = $rw['ext'] ?? '';
                                                 $designation = $rw['designation'] ?? '';
                                             }
                                             if ($stmt) mysqli_stmt_close($stmt);
                                         } else {
                                             $stmt = mysqli_prepare($con, "SELECT fullname, ext, designation FROM staff WHERE staff_id = ? LIMIT 1");
                                             mysqli_stmt_bind_param($stmt, 'i', $sender);
                                             mysqli_stmt_execute($stmt);
                                             $r = mysqli_stmt_get_result($stmt);
                                             if ($r && $rw = mysqli_fetch_assoc($r)) {
                                                 $fullname = $rw['fullname'] ?? '';
                                                 $ext = $rw['ext'] ?? '';
                                                 $designation = $rw['designation'] ?? '';
                                             }
                                             if ($stmt) mysqli_stmt_close($stmt);
                                         }
                                            ?>
                                                                            <h3><?php echo htmlspecialchars($fullname, ENT_QUOTES); ?></h3>
                        </div>
                        <div>
                            <div class="ibox-content no-padding border-left-right" style="">
                                  <?php
                      if (empty($ext)) {  ?>
                          <img alt="image" class="img-responsive" src="img/avatar.png" width="100%">
                          <?php
                      } else {
                            if ($sendertype === 'Teachers') { 
                               $imgPath = htmlspecialchars(BASE_URL . '/img/teachers/' . md5((string)$sender) . '.' . $ext, ENT_QUOTES);
                               ?>
                          <img alt="image" class="img-responsive" src="<?php echo $imgPath; ?>" width="100%">
                           <?php } else {
                               $imgPath = htmlspecialchars(BASE_URL . '/img/nonteaching/' . md5((string)$sender) . '.' . $ext, ENT_QUOTES);
                          ?>
                          <img alt="image" class="img-responsive" src="<?php echo $imgPath; ?>" width="100%">
                      <?php } } ?>
                            </div>
                            <div class="ibox-content profile-content">
                                <h4><strong><?php echo htmlspecialchars($designation, ENT_QUOTES); ?></strong></h4>
                                                 
                            </div>
                    </div>
                </div>
                    </div>
                <div class="col-md-9">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                          
                            <h3> Posted on <?php echo htmlspecialchars(date('d/M/Y', (int)$timestamp) . ' to ' . $to, ENT_QUOTES); ?></h3>
                        </div>
                     
                         
                                  <div class="ibox-content">                           
                       <?php
                       echo nl2br(htmlspecialchars($notification, ENT_QUOTES));
                       ?>
                              
                        
                                                     </div>
                    </div>
                </div>
        

                </div>
           
            </div>
                
                   </div>
    <?php } ?>
    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>


</body>

</html>
