<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
  header('Location:login.php');
  exit;
}
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
  header('Location:timetable.php');
  exit;
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Weekly Plan</title>

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/datapicker/datepicker3.css" rel="stylesheet">
  <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>
  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'nav.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-11">
          <?php
          if (isset($_POST['submit'])) {
            // Validate and normalize inputs
            $start_ts = false;
            $end_ts = false;
            if (!empty($_POST['startdate'])) {
              $start_ts = strtotime(trim($_POST['startdate']));
            }
            if (!empty($_POST['enddate'])) {
              $end_ts = strtotime(trim($_POST['enddate']));
            }
            $term = filter_input(INPUT_POST, 'term', FILTER_VALIDATE_INT);
            // $period = $_POST['period'];
            // $getdate = $_POST['getdate'];
            // $pagenumbers = $_POST['pagenumbers'];
            // $objectives = $_POST['objectives'];
            // $topictoday = $_POST['topictoday'];
            // $previouslesson = $_POST['previouslesson'];
            // $lessonintroduction = $_POST['lessonintroduction'];
            // $newlesson = $_POST['newlesson'];
            // $guidedpractice = $_POST['guidedpractice'];
            // $lessonreview = $_POST['lessonreview'];
            // $individualpractice = $_POST['individualpractice'];
            // $teachingaids = $_POST['teachingaids'];
            if (!$start_ts || !$end_ts || !$term) {
              echo '<div class="alert alert-danger">' . htmlspecialchars('Oops!! Some Fields Are Empty', ENT_QUOTES) . '</div>';
            } else {
              // $addbook =  mysqli_query($con, "INSERT INTO weeklyplans(class_sub_id,teacher_id,startdate,enddate,bookpages,periodsperweek,year,term,weeklyplandoc,timestamp,status) VALUES('$id','" . $_SESSION['teachersys'] . "','$startdate','$enddate','','','','$term','$weeklyplandoc','$timenow',1)");
              // $last_id =  mysqli_insert_id($con);
              // $lessons = sizeof($getdate);
              // for ($i = 0; $i < $lessons; $i++) {
              //   $status = 1;
              //   $byrs = $con->prepare("INSERT INTO lessonplans(weeklyplan_id,period,date,pagenumbers,objectives,topictoday,previouslesson,lessonintroduction,newlesson,guidedpractice,lessonreview,individualpractice,teachingaids,status)  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)") or die(mysqli_error($con));
              //   $byrs->bind_param('issssssssssssi', $last_id, $period[$i], $getdate[$i], $pagenumbers[$i], $objectives[$i], $topictoday[$i], $previouslesson[$i], $lessonintroduction[$i], $newlesson[$i], $guidedpractice[$i], $lessonreview[$i], $individualpractice[$i], $teachingaids[$i], $status);
              //   $byrs->execute();
              // }
              // echo '<div class="alert alert-success">Weekly Plan succesfully Added</div>';

              $upload_dir = __DIR__ . "/../uploads/weekly_plans/";
              if (!file_exists($upload_dir)) {
                mkdir($upload_dir, 0777, true);
              }

              // Prepare insert statement once
              $insertSql = "INSERT INTO weeklyplans(class_sub_id,teacher_id,startdate,enddate,bookpages,periodsperweek,year,term,weeklyplandoc,timestamp,status) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
              $insertStmt = mysqli_prepare($con, $insertSql);
              if (!$insertStmt) {
                echo '<div class="alert alert-danger">' . htmlspecialchars('Database error: could not prepare statement', ENT_QUOTES) . '</div>';
              }

              // Handle file uploads
              if (!empty($_FILES['weeklyplandoc'])) {
                $files = $_FILES['weeklyplandoc'];
                $file_count = is_array($files['name']) ? count($files['name']) : 0;

                for ($i = 0; $i < $file_count; $i++) {
                  if (($files['error'][$i] ?? 1) !== UPLOAD_ERR_OK) continue;

                  $file_name = $files['name'][$i];
                  $file_tmp = $files['tmp_name'][$i];
                  $file_size = $files['size'][$i] ?? 0;
                  $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

                  // Basic checks
                  if ($file_ext !== 'pdf') {
                    echo '<div class="alert alert-danger">' . htmlspecialchars('Only PDF files are allowed!', ENT_QUOTES) . '</div>';
                    continue;
                  }
                  if ($file_size > 5 * 1024 * 1024) { // 5 MB limit
                    echo '<div class="alert alert-danger">' . htmlspecialchars('File too large; max 5MB', ENT_QUOTES) . '</div>';
                    continue;
                  }

                  // Build a safe, unique filename
                  $safeBase = preg_replace('/[^a-zA-Z0-9_-]/', '', pathinfo($file_name, PATHINFO_FILENAME));
                  $unique = uniqid((string)$id . '_' . (string)($_SESSION['teachersys'] ?? 't'), true);
                  $destName = $safeBase . '_' . $unique . '.' . $file_ext;
                  $destPath = $upload_dir . $destName;

                  if (move_uploaded_file($file_tmp, $destPath)) {
                    // Convert timestamps to date strings (Y-m-d)
                    $startdate_db = date('Y-m-d', $start_ts);
                    $enddate_db = date('Y-m-d', $end_ts);
                    $bookpages = '';
                    $periodsperweek = '';
                    $year = '';
                    $term_int = (int)$term;
                    $weeklyplandoc_db = 'uploads/weekly_plans/' . $destName; // path relative to project root
                    $timestamp_db = isset($timenow) ? (string)$timenow : date('Y-m-d H:i:s');
                    $status = 1;

                    if ($insertStmt) {
                      mysqli_stmt_bind_param($insertStmt, 'iisssssissi', $id, $_SESSION['teachersys'], $startdate_db, $enddate_db, $bookpages, $periodsperweek, $year, $term_int, $weeklyplandoc_db, $timestamp_db, $status);
                      $exec = mysqli_stmt_execute($insertStmt);
                      if (!$exec) {
                        echo '<div class="alert alert-danger">' . htmlspecialchars('Error saving to database: ' . mysqli_stmt_error($insertStmt), ENT_QUOTES) . '</div>';
                      }
                    }
                  } else {
                    echo '<div class="alert alert-danger">' . htmlspecialchars('Error uploading file!', ENT_QUOTES) . '</div>';
                  }
                }

                if ($insertStmt) mysqli_stmt_close($insertStmt);

                echo '<div class="alert alert-success">' . htmlspecialchars('Weekly Plan successfully Added', ENT_QUOTES) . '</div>';
              }
            }
          }

          ?>
          <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
            <section class="panel">
              <header class="panel-heading">
                Add Weekly Plan
              </header>
              <div class="panel-body">

                <div class="row">
                  <div class="form-group col-lg-4" id="data_5">
                    <label class=" control-label">*Start & End Dates</label>
                    <div class="input-daterange input-group" id="datepicker">
                      <input type="text" class="input-sm form-control" name="startdate" required="required" />
                      <span class="input-group-addon">to</span>
                      <input type="text" class="input-sm form-control" name="enddate" required="required" />
                    </div>

                  </div>
                  <!-- <div class="form-group col-lg-4"><label class="control-label">Total Pages of Textbook</label>
                    <input type="text" name="bookpages" class="form-control" placeholder="Enter  Book Pages">
                  </div> -->
                  <div class="form-group col-lg-4">
                    <label class="control-label">Select Term</label>
                    <select name="term" class="form-control">
                      <option value="" selected="selected">Select ...</option>
                      <option value="1">1</option>
                      <option value="2">2</option>
                      <option value="3">3</option>
                    </select>
                  </div>
                </div>
              </div>
            </section>

            <section class="panel">
              <header class="panel-heading">
                Add Weekly Plan
              </header>
              <div class="panel-body">
                <div class="pharmacy-sec">
                  <div class="row">
                    <div class="form-group col-lg-11">
                      <label class="control-label">Upload Weekly Plan (PDF)</label>
                      <input type="file" name="weeklyplandoc[]" class="form-control" accept=".pdf" required>
                      <small class="text-muted">Please upload a PDF file containing your weekly lesson plan</small>
                    </div>
                  </div>
                </div>
                <div class="form-group">
                  <button class="drug_button btn btn-info btn-xs">Add more</button>
                </div>

              </div>

            </section>

            <div class="form-group col-lg-12">
              <button class="btn btn-primary" type="submit" name="submit">Add Plan</button>
            </div>

          </form>
        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>

  </div>
  <!-- main content end-->
  </section>

  <script src="<?php echo BASE_URL; ?>/js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery-migrate-1.2.1.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/modernizr.min.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.nicescroll.js"></script>
  <script src="<?php echo BASE_URL; ?>/datapicker/bootstrap-datepicker.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/scripts.js"></script>
  <script src="<?php echo BASE_URL; ?>/js/pickers-init.js"></script>
  <script src="<?php echo BASE_URL; ?>/prettyphoto/js/jquery.prettyPhoto.js" type="text/javascript" charset="utf-8"></script>
  <script src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js"></script>

  <script>
    $('#data_5 .input-daterange').datepicker({
      keyboardNavigation: false,
      forceParse: false,
      autoclose: true
    });
  </script>
  <script>
    $('.drug_button').click(function(e) { //on add input button click
      e.preventDefault();
      $(document).ready(function() {
        $('.pharmacy-sec').append(`
          <div class="row">
            <div class="col-lg-12">
              <strong style="font-size:14px;color:#000">ADD WEEKLY PLAN</strong>
            </div>
            <div class="form-group col-lg-11">
              <label class="control-label">Upload Weekly Plan (PDF)</label>
              <input type="file" name="weeklyplandoc[]" class="form-control" accept=".pdf" required>
              <small class="text-muted">Please upload a PDF file containing your weekly lesson plan</small>
            </div>
            <button class="remove_drug btn btn-danger btn-sm" style="margin-top:20px">
              <i class="fa fa-minus"></i>
            </button>
          </div>
        `);
      });

      $('.pharmacy-sec').on("click", ".remove_drug", function(e) { //user click on remove text
        e.preventDefault();
        $(this).parent('div').remove();
      });
    });
  </script>

</body>

</html>