<?php
include '../includes/conn.php';
if (!isset($_SESSION['teachersys'])) {
    header('Location:login.php');
    exit;
}

// validate id param
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($id <= 0) {
    header('Location: teacher');
    exit;
}

// load subject safely
$subject = '';
$class_id = 0;
$subject_id = 0;
$stmt = mysqli_prepare($con, "SELECT subject, class_id, subject_id FROM subjects WHERE subject_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $subject_col, $class_id_col, $subject_id_col);
    if (mysqli_stmt_fetch($stmt)) {
        $subject = $subject_col;
        $class_id = (int)$class_id_col;
        $subject_id = (int)$subject_id_col;
    }
    mysqli_stmt_close($stmt);
}

if ($subject_id <= 0) {
    echo '<div class="alert alert-danger">Invalid subject selected.</div>';
    exit;
}

// load class safely
$class = '';
$stmt = mysqli_prepare($con, "SELECT class FROM classes WHERE class_id = ? LIMIT 1");
if ($stmt) {
    mysqli_stmt_bind_param($stmt, 'i', $class_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_bind_result($stmt, $class_col);
    if (mysqli_stmt_fetch($stmt)) {
        $class = $class_col;
    }
    mysqli_stmt_close($stmt);
}
?>
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

     <title>Add Learning area info-School Manager</title>
     <script src="<?php echo BASE_URL; ?>/ckeditor/ckeditor.js"></script>
   <link rel="stylesheet" href="<?php echo BASE_URL; ?>/ckeditor/samples/sample.css">
    <link href="<?php echo BASE_URL; ?>/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/font-awesome/css/font-awesome.css" rel="stylesheet">
    <!--<link href="css/plugins/iCheck/custom.css" rel="stylesheet">-->
    <link href="<?php echo BASE_URL; ?>./css/animate.css" rel="stylesheet">
      <link href="<?php echo BASE_URL; ?>./css/plugins/chosen/chosen.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
   <link href="<?php echo BASE_URL; ?>/css/plugins/datapicker/datepicker3.css" rel="stylesheet">
 <link href="<?php echo BASE_URL; ?>/css/jquery.filer.css" type="text/css" rel="stylesheet" />
</head>

<body>

    <div id="wrapper">

        <?php include 'nav.php'; ?>

        <div id="page-wrapper" class="gray-bg">
        <div class="row border-bottom">
        <nav class="navbar navbar-static-top" role="navigation" style="margin-bottom: 0">
        <div class="navbar-header">
            <a class="navbar-minimalize minimalize-styl-2 btn btn-primary " href="#"><i class="fa fa-bars"></i> </a>
          
        </div>
            <ul class="nav navbar-top-links navbar-right">
               
                <li>
                    <a href="logout">
                        <i class="fa fa-sign-out"></i> Log out
                    </a>
                </li>
            </ul>

        </nav>
        </div>
            <div class="row wrapper border-bottom white-bg page-heading">
                <div class="col-lg-10">
                    <h2>Add Learning outcome  for <?php echo $subject.' : '.$class; ?></h2>
                    <ol class="breadcrumb">
                        <li>              <a href=""><i class="fa fa-home"></i> Home</a>                    </li>
                
                        <li class="active">
                            <strong>Add Info</strong>
                        </li>
                    </ol>
                </div>
                <div class="col-lg-2">

                </div>
            </div>
        <div class="wrapper wrapper-content">
                                <div class="row">
                <div class="col-lg-10">
                    <div class="ibox float-e-margins">
                        <div class="ibox-title">
                            <h5>Select to Proceed<small>  All  fields marked (*) shouldn't be left blank</small></h5>                           
                        </div>
                        <div class="ibox-content">
            <?php
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['term'], $_POST['description'])) {
                $errors = [];
                $term = (int)($_POST['term'] ?? 0);
                $description = (string)($_POST['description'] ?? '');

                if ($term <= 0) {
                    $errors[] = 'Select Term to Proceed';
                }

                // check duplicate with prepared statement
                if (empty($errors)) {
                    $chk = mysqli_prepare($con, "SELECT 1 FROM subjectdetails WHERE subject_id=? AND term=? AND status=1 LIMIT 1");
                    if ($chk) {
                        mysqli_stmt_bind_param($chk, 'ii', $id, $term);
                        mysqli_stmt_execute($chk);
                        mysqli_stmt_store_result($chk);
                        if (mysqli_stmt_num_rows($chk) > 0) {
                            $errors[] = 'Details for that term already added';
                        }
                        mysqli_stmt_close($chk);
                    } else {
                        $errors[] = 'Database error';
                    }
                }

                if (!empty($errors)) {
                    foreach ($errors as $error) {
                        echo '<div class="alert alert-danger">' . htmlspecialchars($error) . '</div>';
                    }
                } else {
                    // insert subjectdetails
                    $ins = mysqli_prepare($con, "INSERT INTO subjectdetails (term, subject_id, description, status) VALUES (?, ?, ?, 1)");
                    if ($ins) {
                        mysqli_stmt_bind_param($ins, 'iis', $term, $id, $description);
                        $ok = mysqli_stmt_execute($ins);
                        if ($ok) {
                            $last_id = mysqli_insert_id($con);

                            // handle file uploads safely
                            $uploads_dir = __DIR__ . '/../parent/attachments/subdocs';
                            if (!is_dir($uploads_dir)) mkdir($uploads_dir, 0755, true);

                            $allowed_ext = ['jpg','jpeg','png','xls','xlsx','doc','docx','pdf','gif'];
                            $max_size = 10097152; // ~10MB

                            for ($x = 0; $x < count($_FILES['uploads']['name']); $x++) {
                                $fileName = $_FILES['uploads']['name'][$x] ?? '';
                                $fileTmpLoc = $_FILES['uploads']['tmp_name'][$x] ?? '';
                                $fileSize = $_FILES['uploads']['size'][$x] ?? 0;
                                $kaboom = explode('.', $fileName);
                                $fileExt = strtolower(end($kaboom));

                                if ($fileName === '' || $fileTmpLoc === '') continue;

                                if (!in_array($fileExt, $allowed_ext, true)) {
                                    echo '<div class="alert alert-danger">File type not allowed: ' . htmlspecialchars($fileName) . '</div>';
                                    continue;
                                }
                                if ($fileSize > $max_size) {
                                    echo '<div class="alert alert-danger">File too large: ' . htmlspecialchars($fileName) . '</div>';
                                    continue;
                                }

                                // insert doc record
                                $insdoc = mysqli_prepare($con, "INSERT INTO subjectdocs (ext, subdetails_id, status) VALUES (?, ?, 1)");
                                if ($insdoc) {
                                    mysqli_stmt_bind_param($insdoc, 'si', $fileExt, $last_id);
                                    mysqli_stmt_execute($insdoc);
                                    mysqli_stmt_close($insdoc);
                                    $photo_id = mysqli_insert_id($con);
                                    if ($photo_id > 0) {
                                        $image_name = md5($photo_id);
                                        $image_file = $image_name . '.' . $fileExt;
                                        $dest = $uploads_dir . '/' . $image_file;
                                        if (!move_uploaded_file($fileTmpLoc, $dest)) {
                                            echo '<div class="alert alert-danger">Failed to move upload: ' . htmlspecialchars($fileName) . '</div>';
                                        }
                                    }
                                } else {
                                    echo '<div class="alert alert-danger">Failed to save attachment record.</div>';
                                }
                            }

                            echo '<div class="alert alert-success">Info Successfully Added</div>';
                        } else {
                            echo '<div class="alert alert-danger">Insert failed: ' . htmlspecialchars(mysqli_stmt_error($ins)) . '</div>';
                        }
                        mysqli_stmt_close($ins);
                    } else {
                        echo '<div class="alert alert-danger">Database error: ' . htmlspecialchars(mysqli_error($con)) . '</div>';
                    }
                }
            }

            ?>
 <form method="POST"  name='form' class="form" action=""  enctype="multipart/form-data">
    
                                        <div class="form-group"><label class="control-label">* Term</label>
                                                  <select name='term' class="form-control" >
                                        <option value="" selected="selected">Select Term.....</option>                                            
                                        <option value="1">Term 1</option>                                            
                                        <option value="2">Term 2</option>                                            
                                        <option value="3">Term 3</option>              
                                         </select>
                                                                          
                                </div>                                                                                 
                                  <div class="hr-line-dashed"></div>
                                   <div class="form-group">
                                            <label class="control-label">Description</label>
                                                     <textarea class="ckeditor" cols="80" id="editor1" name="description" rows="100">                                            
                                                </textarea>
                                                                                                                        </div>
                                                                                       <div class="hr-line-dashed"></div>
                                                                    <div class="form-group">
                                                          <label>Upload Attachments(Must be an image or word,PDF,Excel Document)*</label>
                                                    <input type="file" name="uploads[]"  id="filer_input" multiple="multiple">
                                                    </div>                    
                                   
                                <div class="form-group">                                                                
                                        <button class="btn btn-primary" type="submit">Submit</button>
                                                              </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>


    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>
     <script type="text/javascript" src="<?php echo BASE_URL; ?>/js/jquery.filer.min.js?v=1.0.5"></script>
    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/pace/pace.min.js"></script>
    <script>
         $(document).ready(function() {             
                     $('#filer_input').filer({
		showThumbs: true,
		addMore: true
    });
    });
    </script>
</body>

</html>
 