<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2], true)) {
    header('Location: login.php');
    exit;
}

$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
$term_id = isset($_GET['term']) ? (int) $_GET['term'] : 0;
if ($id <= 0 || $term_id <= 0) {
    header('Location: students.php');
    exit;
}

// load student
$getstudent = mysqli_query($con, "SELECT * FROM students WHERE status=1 AND student_id={$id} LIMIT 1");
$row = $getstudent ? mysqli_fetch_assoc($getstudent) : null;
if (!$row) {
    header('Location: students.php');
    exit;
}
$regnumber = $row['regnumber'] ?? '';
$student_id = (int) ($row['student_id'] ?? 0);
$fullname = $row['fullname'] ?? '';

// load term
$terms = mysqli_query($con, "SELECT * FROM financialterms WHERE financialterm_id={$term_id} LIMIT 1");
$row1 = $terms ? mysqli_fetch_assoc($terms) : null;
$term = $row1['term'] ?? '';
$year = $row1['year'] ?? '';
              ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="ThemeBucket">
  <link rel="shortcut icon" href="#" type="image/png">

  <title><?php echo 'Term '.$term.' '.$year;?>  Attendance for <?php echo $fullname; ?></title>
<link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_page.css" rel="stylesheet" />
  <link href="<?php echo BASE_URL; ?>/js/advanced-datatable/css/demo_table.css" rel="stylesheet" />
  <link rel="stylesheet" href="<?php echo BASE_URL; ?>/js/data-tables/DT_bootstrap.css" />

  <link href="<?php echo BASE_URL; ?>/css/style.css" rel="stylesheet">
  <link href="<?php echo BASE_URL; ?>/css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
<section>
   <?php include 'includes/header.php'; ?>

        <section class="wrapper">
        <!-- page start-->
<div class="row states-info">
            <div class="col-md-3">
                <div class="panel green-bg">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-4">
                                <i class="fa fa-thumbs-up"></i>
                            </div>
                            <div class="col-xs-8">
                                <span class="state-title">Days Present</span>
                                 <?php 
                                 $daysattended = 0;
                                  $attendance = mysqli_query($con, "SELECT * FROM attendance WHERE status=1 AND term_id={$term_id} GROUP BY date");
                                  if ($attendance) {
                                  while ($row = mysqli_fetch_assoc($attendance)) {
                                      $attendance_id = (int) ($row['attendance_id'] ?? 0);
                                    $attendees = mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id={$attendance_id} AND student_id={$id} AND status=1");
                                       if ($attendees && mysqli_num_rows($attendees) > 0) {
                                           $daysattended++;
                                       }
                                  }
                                  }
                                ?>
                                <h4><?php    echo $daysattended; ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
       <div class="col-md-3">
                <div class="panel red-bg">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-xs-4">
                                <i class="fa fa-thumbs-down"></i>
                            </div>
                               <div class="col-xs-8">
                                <span class="state-title">Days Absent</span>
                                 <?php 
                                 $daysattended = 0;
                                  $attendance = mysqli_query($con, "SELECT * FROM attendance WHERE status=1 AND term_id={$term_id} GROUP BY date");
                                  if ($attendance) {
                                  while ($row = mysqli_fetch_assoc($attendance)) {
                                      $attendance_id = (int) ($row['attendance_id'] ?? 0);
                                    $attendees = mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id={$attendance_id} AND student_id={$id} AND status=0");
                                       if ($attendees && mysqli_num_rows($attendees) > 0) {
                                           $daysattended++;
                                       }
                                  }
                                  }
                                ?>
                                <h4><?php    echo $daysattended; ?></h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        <div class="row">
        
    <div class="col-lg-8">
                      <section class="panel">
                    <header class="panel-heading">
            <?php echo 'Term '.$term.' '.$year;?>  Attendance for <?php echo $fullname; ?>
                    </header>
                          <div class="panel-body">
                              <p style="font-style: italic"><strong>NB:</strong> Red represents day absent and Green Represents Day Present</p>
                                                     <?php 
                                                                 $attendance = mysqli_query($con, "SELECT * FROM attendance WHERE status=1 AND term_id={$term_id} GROUP BY date ORDER BY date");
                                                                 if ($attendance) {
                                                                    while ($row = mysqli_fetch_assoc($attendance)) {
                                                                            $attendance_id = (int) ($row['attendance_id'] ?? 0);
                                                                            $date = (int) ($row['date'] ?? 0);
                                                                        $attendees = mysqli_query($con, "SELECT * FROM attendancedetails WHERE attendance_id={$attendance_id} AND student_id={$id}");
                                                                             if ($attendees && mysqli_num_rows($attendees) > 0) {
                                                                        $row1 = mysqli_fetch_assoc($attendees);
                                                                        $status = (int) ($row1['status'] ?? 0);     
                                                                        if ($status == 1) {
                                                                ?>
                                                            <span class="label label-success" style="padding: 5px;border-radius: 0;"><?php echo htmlspecialchars(date('d/M/Y', $date)); ?></span>
                                                                        <?php } else { ?>
<span class="label label-danger" style="padding: 5px;border-radius: 0;"><?php echo htmlspecialchars(date('d/M/Y', $date)); ?></span>
                                                                             <?php   } } } } ?>
                                                      </div>
                          </div>
   
        </div>
    

        </div>
        <!-- page end-->
        </section>
        <!--body wrapper end-->

        <!--footer section start-->
      
        <!--footer section end-->


    </div>
    <!-- main content end-->
</section>

<script src="<?php echo BASE_URL;?>/js/jquery-1.10.2.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-ui-1.9.2.custom.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery-migrate-1.2.1.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/bootstrap.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/modernizr.min.js"></script>
<script src="<?php echo BASE_URL;?>/js/jquery.nicescroll.js"></script>
<script type="text/javascript" language="javascript" src="<?php echo BASE_URL;?>/js/advanced-datatable/js/jquery.dataTables.js"></script>
<script type="text/javascript" src="<?php echo BASE_URL;?>/js/data-tables/DT_bootstrap.js"></script>
<script src="<?php echo BASE_URL;?>/js/dynamic_table_init.js"></script>
<script src="<?php echo BASE_URL;?>/js/scripts.js"></script>

</body>
</html>
