<?php
include 'includes/conn.php';

// Require a logged-in user with proper level
if (!isset($_SESSION['schoolsyslevel']) || !in_array((int)$_SESSION['schoolsyslevel'], [1,2], true)) {
	header('Location: login.php');
	exit;
}

header('Content-Type: application/json');

if (!isset($_GET['item']) || !is_array($_GET['item'])) {
	http_response_code(400);
	echo json_encode(['success' => false, 'message' => 'Invalid request: items missing']);
	exit;
}

$stmt = mysqli_prepare($con, "UPDATE timetables SET position = ? WHERE timetable_id = ? AND status=1");
if (!$stmt) {
	http_response_code(500);
	echo json_encode(['success' => false, 'message' => 'DB error']);
	exit;
}

$failed = 0;
foreach ($_GET['item'] as $key => $id) {
	$position = (int)$key + 1;
	$timetable_id = (int)$id;
	if ($timetable_id <= 0) {
		// skip invalid ids
		continue;
	}
	mysqli_stmt_bind_param($stmt, 'ii', $position, $timetable_id);
	if (!mysqli_stmt_execute($stmt)) {
		$failed++;
	}
}

mysqli_stmt_close($stmt);

echo json_encode(['success' => $failed === 0, 'failed' => $failed]);

?>