<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsyslevel']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location:login');
    exit;
}

// Safe query helper
function sq($con, $sql) {
    $res = mysqli_query($con, $sql);
    if ($res === false) {
        $err = mysqli_error($con);
        die("<strong>Database query error:</strong> " . htmlspecialchars($err) . "<br><strong>SQL:</strong> " . htmlspecialchars($sql));
    }
    return $res;
}

$std = isset($_GET['std']) ? mysqli_real_escape_string($con, $_GET['std']) : '';
$tm  = isset($_GET['tm'])  ? mysqli_real_escape_string($con, $_GET['tm'])  : '';

// Get student's class and class category ID
$student_query = sq($con, "SELECT class_id, fullname, student_id FROM students WHERE student_id = '$std' LIMIT 1");
$student_data = mysqli_fetch_array($student_query);
$student_class_id = $student_data['class_id'];
$fullname = $student_data['fullname'];
$student_id = $student_data['student_id'];
// Get class category ID from the student's class
$class_query = sq($con, "SELECT * FROM classes WHERE class_id = '$student_class_id' LIMIT 1");
$class_data = mysqli_fetch_array($class_query);
$class_id = $class_data['class_id'];
$class = $class_data['class'];
$report_type = $class_data['report_type'];
$aveage_type = $class_data['average_type'];
$category_id = $class_data['category_id'];

// Get class category name
$getcat = sq($con, "SELECT * FROM classcategories WHERE classcategory_id='$category_id'");
$rowc = mysqli_fetch_array($getcat);
$classcategory = $rowc['classcategory'];

// Load term info
$getterm = sq($con, "SELECT ft.*, fy.fyear FROM financialterms ft INNER JOIN financialyears fy ON ft.academic_year=fy.fyear_id WHERE ft.financialterm_id='$tm' LIMIT 1");
$row4 = mysqli_fetch_array($getterm);
$term2 = $row4['term'];
$year = $row4['year'];
$academic_year = $row4['fyear'];
$startdate_4 = $row4['startdate'];
$enddate_4 = $row4['enddate'];
$notice = isset($row4['important_notice']) ? $row4['important_notice'] : '';

// Get principal/headteacher and signatures
$getdirector = sq($con, "SELECT * FROM users WHERE level=2 AND status=1 LIMIT 1");
$rowd = mysqli_fetch_array($getdirector);
$staff_id1 = $rowd['staff_id'];
$getstaff1 = sq($con, "SELECT * FROM staff WHERE staff_id='$staff_id1' LIMIT 1");
$rows1 = mysqli_fetch_array($getstaff1);
$fullname2 = $rows1['fullname'];

$headteacher = sq($con, "SELECT * FROM staff WHERE designation='Head Teacher' AND status=1 LIMIT 1");
$rowh = mysqli_fetch_array($headteacher);
$hsign_ext = $rowh['sign_ext'];
$staff_id2 = $rowh['staff_id'];
$headteachername = $rowh['fullname'];

$pteacher = sq($con, "SELECT * FROM staff WHERE designation='Principal' AND status=1 LIMIT 1");
$rowp = mysqli_fetch_array($pteacher);
$psign_ext = $rowp['sign_ext'];
$staff_id3 = $rowp['staff_id'];
$principalname = $rowp['fullname'];

// Load grading config (custom or default)
// Load grading config (custom for the class category). If none found, fall back to built-in defaults.
$grades = [];
$grades_query = sq($con, "SELECT grade_letter, grade_modifier, mark_range FROM grade_config WHERE classcategory_id = '{$class_data['category_id']}' ORDER BY grade_letter DESC, grade_modifier DESC");
if ($grades_query && mysqli_num_rows($grades_query) > 0) {
    while ($g = mysqli_fetch_assoc($grades_query)) {
        $label = $g['grade_letter'] . ($g['grade_modifier'] ?? '');
        $range = trim($g['mark_range']);
        // normalize display: remove percent signs and fix spacing
        $r = str_replace('%', '', $range);
        $r = preg_replace('/\s*-\s*/', '-', $r);
        $r = $r . '%';
        $grades[] = array('label' => $label, 'range' => $r);
    }
} else {
    // default grading map (kept as sensible defaults)
    $grades = array(
        array('label' => 'A*', 'range' => '86-100%'),
        array('label' => 'A',  'range' => '81-85%'),
        array('label' => 'B+', 'range' => '76-80%'),
        array('label' => 'B',  'range' => '71-75%'),
        array('label' => 'B-', 'range' => '66-70%'),
        array('label' => 'C+', 'range' => '61-65%'),
        array('label' => 'C',  'range' => '56-60%'),
        array('label' => 'C-', 'range' => '51-55%'),
        array('label' => 'D',  'range' => '41-50%'),
        array('label' => 'E',  'range' => '31-40%'),
        array('label' => 'U',  'range' => '0-30%')
    );
}

/**
 * Helper: find grade label from numeric percentage using $grades map
 */
function find_grade_from_percent($percent, $grades_map) {
    if ($percent === null || $percent === '' || strtoupper($percent) === 'N/A') return 'N/A';
    $p = intval($percent);

    // Detect if $grades_map is an indexed array of ['label'=>..., 'range'=>...]
    $isIndexed = array_keys($grades_map) === range(0, count($grades_map) - 1);

    if ($isIndexed) {
        foreach ($grades_map as $entry) {
            $label = isset($entry['label']) ? $entry['label'] : '';
            $range = isset($entry['range']) ? $entry['range'] : '';
            $range = str_replace('%', '', $range);
            if (strpos($range, '-') !== false) {
                list($min, $max) = explode('-', $range, 2);
                $min = intval(trim($min));
                $max = intval(trim($max));
                // normalize if min > max
                if ($min > $max) {
                    $tmp = $min; $min = $max; $max = $tmp;
                }
                if ($p >= $min && $p <= $max) return $label;
            }
        }
        return 'U';
    }

    // associative map (legacy)
    foreach ($grades_map as $g => $range) {
        $r = str_replace('%', '', $range);
        if (strpos($r, '-') !== false) {
            list($min, $max) = explode('-', $r, 2);
            $min = intval(trim($min));
            $max = intval(trim($max));
            if ($min > $max) { $tmp = $min; $min = $max; $max = $tmp; }
            if ($p >= $min && $p <= $max) return $g;
        }
    }
    return 'U';
}
                

/**
 * Normalize DB-mark using rank — returns rounded integer percent of given maxWeight
 * $rawMark = marks from DB, $rank = max possible (e.g. 50) used to scale, $scaleTo = weight (40 or 60)
 */
function normalize_mark($rawMark, $rank, $scaleTo) {
    if ($rawMark === null || $rawMark === '' || strtoupper($rawMark) === 'N/A') return null;
    if (intval($rank) == 0) return null;
    $raw = floatval($rawMark);
    $rk = floatval($rank);
    $percentOfFull = ($raw / $rk); // 0..1
    $scaled = round($percentOfFull * $scaleTo);
    return intval($scaled);
}

// load papers (for multi-paper reports)
$getpapers = sq($con, "SELECT * FROM papers WHERE status='1' ORDER BY paper_id");
$papers = [];
while ($p = mysqli_fetch_array($getpapers)) {
    $papers[] = $p;
}

// get subjects for class
$classmarks = sq($con, "SELECT * FROM class_subjects WHERE class_id='$class_id' ORDER BY subject_id");

$getabsence = sq($con, "SELECT * FROM attendance WHERE term_id='$tm' AND class_id='$class_id'");
$absent = 0; $present = 0; $present2 = 0;
while ($rowt = mysqli_fetch_array($getabsence)) {
    $attendance_id = $rowt['attendance_id'];
    $getabsence2 = sq($con, "SELECT * FROM attendancedetails WHERE status=0 AND student_id='$std' AND attendance_id='$attendance_id'");
    $getpresent = sq($con, "SELECT * FROM attendancedetails WHERE status=1 AND student_id='$std' AND attendance_id='$attendance_id'");
    $getpresent2 = sq($con, "SELECT * FROM attendancedetails WHERE status=2 AND student_id='$std' AND attendance_id='$attendance_id'");
    $absent += ($getabsence2) ? mysqli_num_rows($getabsence2) : 0;
    $present += ($getpresent) ? mysqli_num_rows($getpresent) : 0;
    $present2 += ($getpresent2) ? mysqli_num_rows($getpresent2) : 0;
}
$overall_days = $absent + $present + $present2;

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Progress Report - <?php echo htmlspecialchars($fullname); ?></title>

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Print / PDF A4 settings -->
    <style>
        @page {
            size: A4;
            margin: 20mm;
        }
        html,body{
            font-family: Arial, "Helvetica Neue", Helvetica, sans-serif;
            color: #000;
            height: 100%;
            -webkit-print-color-adjust: exact;
        }
        body { margin: 0; padding: 0; background: #fff; }

        .container {
            /* Add left/right padding to provide consistent margins for screen and print */
            width: 100%;
            box-sizing: border-box;
            padding: 0 20mm; /* matches the @page margin for consistent print output */
        }

        /* Media-specific fixes: screen uses px-based paddings, print uses mm */
        @media screen {
            .container { padding: 0 20px; max-width: 100%; }
            .effort-box { width: calc(100% - 40px) !important; max-width: calc(100% - 40px) !important; }
        }
        @media print {
            .container { padding: 0 20mm; max-width: calc(100% - 40mm); }
            .effort-box { width: calc(100% - 40mm) !important; max-width: calc(100% - 40mm) !important; }
        }

        /* Header */
        .report-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 12px;
            margin-bottom: 8px;
        }
        .header-left {
            flex: 1 1 65%;
        }
        .school-title {
            font-family: "Georgia", "Times New Roman", serif;
            color: #1f67a8;
            font-size: 28px;
            margin: 0 0 2px 0;
            font-weight: 700;
        }
        .school-subtitle {
            color: #6aa14e;
            font-size: 14px;
            margin: 0 0 6px 0;
            font-weight: 600;
        }
        .contact-info p { margin: 0; font-size: 12px; }

        .header-right {
            width: 180px;
            text-align: center;
        }
        .school-logo {
            width: 80px;
            height: 80px;
            object-fit: contain;
            border-radius: 50%;
            display: block;
            margin: 0 auto 6px auto;
        }
        .academic-year { font-weight: 700; font-size: 12px; }

        /* Title bar */
        .term-bar {
            background: #d6dce0;
            border: 1px solid #000;
            padding: 8px 12px;
            text-align: center;
            font-weight: 700;
            margin-top: 10px;
            margin-bottom: 10px;
        }

        /* Student info row */
        .student-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 8px;
            font-size: 14px;
        }
        .underline-field {
            border-bottom: 2px solid #000;
            padding-bottom: 4px;
            display: inline-block;
            min-width: 240px;
            margin-left: 6px;
            font-weight: 700;
        }
        .year-field {
            border-bottom: 2px solid #000;
            padding-bottom: 4px;
            min-width: 80px;
            display: inline-block;
            font-weight: 700;
            text-align: center;
        }

        /* Main table */
        .subject-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
            page-break-inside: auto;
        }
        .subject-table thead { display: table-header-group; }
        .subject-table th, .subject-table td {
            border: 1px solid #000;
            padding: 6px 8px;
            vertical-align: middle;
            font-size: 12px;
        }
        .subject-table thead th {
            background: #2f87c8;
            color: #fff;
            font-weight: 700;
            text-transform: none;
            text-align: center;
        }
        .subject-name { text-align: left; font-weight: 600; }
        .num { text-align: center; }

        /* Grading legend */
        .grading-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 12px;
        }
        .grading-table th, .grading-table td {
            border: 1px solid #000;
            padding: 6px;
            font-size: 12px;
            text-align: center;
        }
        .grading-title {
            background: #c6efce;
            font-weight: 700;
        }

        /* Effort box */
        .effort-box {
            margin-top: 12px;
            border: 1px solid #000;
            padding: 6px;
            width: 100% !important;
            max-width: 100% !important;
            display: block !important;
            clear: both !important;
            float: none !important;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }
        .effort-row {
            border-top: 1px solid #000;
            padding: 6px;
            display: flex;
            gap: 10px;
            flex-wrap: nowrap; /* keep rank and description aligned */
            align-items: center;
        }
        .effort-row:first-child { border-top: none; }

        /* Tutor comments */
        .comments {
            /* give more breathing room above and below the comments box */
          
            border: 2px solid #000;
            padding: 10px;
            min-height: 80px;
            box-sizing: border-box;
        }
        .comments h3 {
            margin: 0 0 6px 0;
            padding: 6px;
            background: #c6efce;
            border-bottom: 2px solid #000;
            text-align: center;
        }
        .comments p { margin: 8px 0 0 0; font-size: 13px; }

        /* Attendance box */
        .attendance {
            margin-top: 12px;
            width: 320px;
            border-collapse: collapse;
        }
        .attendance td { border: 1px solid #000; padding: 6px; font-size: 13px; }

        /* Signatures */
        .signatures {
            margin-top: 18px;
            display:flex;
            justify-content: space-between;
            gap: 20px;
        }
        .sign-box { width: 45%; text-align: left; }
        .sign-box img { width: 120px; height: auto; display:block; margin-top: 6px; }

        /* Important notice */
        .notice {
            margin-top: 18px;
            border: 2px solid #000;
            padding: 8px;
            box-sizing: border-box;
        }
        .notice h4 { margin: 0 0 6px 0; background: #c6efce; padding:6px; font-size:14px; text-align:center; border-bottom:2px solid #000; }
        .notice p { margin: 6px 0 0 0; font-size:13px; }

        footer { margin-top: 18px; text-align:center; font-size:11px; color:#444; }

        /* Avoid breaking boxes across pages */
        .comments, .notice, .subject-table, .grading-table, .effort-box { page-break-inside: avoid; }
    </style>
</head>
<body>
<div class="container">
    <!-- Header -->
    <header class="report-header" role="banner">
        <div class="header-left">
            <h1 class="school-title">The King's School</h1>
            <div class="school-subtitle">Christian, English Speaking, International School</div>
            <div class="contact-info" aria-label="school contact information">
                <p>P.O. BOX 1560, Bujumbura, Burundi</p>
                <p>TEL: (+257) 22 27 96 78 / 69 84 04 78</p>
                <p>Email: secondary.school@thekingsschool.edu.bl</p>
                <p>Website: www.thekingsschool.edu.bl</p>
            </div>
        </div>

        <div class="header-right" role="img" aria-label="school logo and academic year">
            <img class="school-logo" src="<?php echo BASE_URL; ?>/images/schoollogo.JPG" alt="The King's School logo">
            <div class="academic-year">ACADEMIC YEAR: <?php echo htmlspecialchars($academic_year); ?></div>
        </div>
    </header>

    <!-- Term title -->
    <div class="term-bar">TERM <?php echo htmlspecialchars($term2); ?> REPORT - <?php echo date('M/Y', $enddate_4); ?></div>

    <!-- Student info -->
    <div class="student-row" role="region" aria-label="student information">
        <div><strong>Student Name:</strong> <span class="underline-field"><?php echo htmlspecialchars($fullname); ?></span></div>
        <div><strong>Year:</strong> <span class="year-field"><?php
                // try to strip year from class name like "Form 7B"
                $class3 = $class;
                $parts = preg_split('/\s+/', trim($class3));
                $yearDisplay = end($parts);
                echo htmlspecialchars($yearDisplay);
            ?></span></div>
    </div>

    <!-- Subject table (Classwork/Exam/Cumulative) -->
    <?php if ($classmarks && mysqli_num_rows($classmarks) > 0): ?>
        <table class="subject-table" role="table" aria-label="subject scores">
            <thead>
                <tr>
                    <th style="text-align:left">Subject</th>
                    <th>Classwork /40</th>
                    <th>Exam /60</th>
                    <th>Cumulative %</th>
                    <th>Grade</th>
                    <th>Effort</th>
                    <th>Class average</th>
                </tr>
            </thead>
            <tbody>
            <?php
            // Rewind pointer and iterate subjects
            if ($classmarks) mysqli_data_seek($classmarks, 0);
            while ($row = mysqli_fetch_array($classmarks)) {
                $subject_id = $row['subject_id'];
                $getsubjects = sq($con, "SELECT * FROM subjects WHERE subject_id='$subject_id' LIMIT 1");
                $row3 = mysqli_fetch_array($getsubjects);
                if (!$row3) continue;
                $subject = $row3['subject'];

                // Get classwork (assessment=1)
                $cwmark = null;
                $cwQuery = sq($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND student_id='$std' AND term_id='$tm' AND subject_id='$subject_id' AND assessment='1' AND status='1' LIMIT 1");
                if ($cwQuery && mysqli_num_rows($cwQuery) > 0) {
                    $cwRow = mysqli_fetch_array($cwQuery);
                    $cwmark_raw = $cwRow['marks'];
                    $cw_rank = $cwRow['rank'] ? $cwRow['rank'] : 0;
                    $cwmark = normalize_mark($cwmark_raw, $cw_rank, 40); // scale to 40
                }

                // Get exam (assessment=2)
                $exammark = null;
                $effort_id = 0;
                $examQuery = sq($con, "SELECT marks, rank, effort_id FROM marks WHERE class_id='$class_id' AND student_id='$std' AND term_id='$tm' AND subject_id='$subject_id' AND assessment='2' AND status='1' LIMIT 1");
                if ($examQuery && mysqli_num_rows($examQuery) > 0) {
                    $exRow = mysqli_fetch_array($examQuery);
                    $exam_raw = $exRow['marks'];
                    $exam_rank = $exRow['rank'] ? $exRow['rank'] : 0;
                    $effort_id = $exRow['effort_id'];
                    $exammark = normalize_mark($exam_raw, $exam_rank, 60); // scale to 60
                }

                // If both null or exam null — treat as N/A (skip printing row if no exam/classwork found)
                if ($exammark === null && $cwmark === null) {
                    // skip subject (not taken or no marks)
                    continue;
                }

                // Cumulative: sum of cw(0-40) + exam(0-60) => 0..100
                $finalmark = 0;
                if ($cwmark !== null) $finalmark += intval($cwmark);
                if ($exammark !== null) $finalmark += intval($exammark);

                // Grade from $grades map
                $grade_label = ($finalmark === null || $finalmark === 0 && $exammark === null) ? 'N/A' : find_grade_from_percent($finalmark, $grades);

                // Effort display
                $effort_display = '';
                if ($effort_id && $effort_id != 0) {
                    $geteff = sq($con, "SELECT rank FROM effort_types WHERE effort_id='$effort_id' LIMIT 1");
                    if ($geteff && mysqli_num_rows($geteff) > 0) {
                        $effrow = mysqli_fetch_array($geteff);
                        $effort_display = $effrow['rank'];
                    }
                }

                // Class average
                $classavg_display = '';
                if ($aveage_type != 0) {
                    // simpler average: average of normalized exam marks from marks table (assessment 2)
                    $getclassavg = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1'");
                    $count = 0; $totalPercent = 0;
                    while ($rowavg = mysqli_fetch_array($getclassavg)) {
                        $m = $rowavg['marks'];
                        $rk = $rowavg['rank'] ? $rowavg['rank'] : 0;
                        if ($m === null || strtoupper($m) === 'N/A' || $rk == 0) continue;
                        $percent = round((intval($m) / intval($rk)) * 100);
                        $totalPercent += $percent;
                        $count++;
                    }
                    if ($count > 0) $classavg_display = round($totalPercent / $count);
                } else {
                    // average across students and papers (approximate), using paper 1 grouping
                    $getStudentsQuery = "SELECT student_id FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' and paper_id='1'";
                    $studentsResult = mysqli_query($con, $getStudentsQuery);
                    $totalStudents = mysqli_num_rows($studentsResult);
                    $totalMarks = [];
                    if ($totalStudents > 0) {
                        while ($studentRow = mysqli_fetch_assoc($studentsResult)) {
                            $studentId = $studentRow['student_id'];
                            // compute student's average percent across papers
                            $paperQuery = mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                            $studentTotalPercent = 0; $paperCount = 0;
                            while ($paperRow = mysqli_fetch_array($paperQuery)) {
                                $paperId = $paperRow['paper_id'];
                                $getMarksQuery = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND paper_id='$paperId' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' AND student_id='$studentId'");
                                $marksCount = mysqli_num_rows($getMarksQuery);
                                if ($marksCount > 0) {
                                    $sumThisPaper = 0; $countThisPaper = 0;
                                    while ($mRow = mysqli_fetch_array($getMarksQuery)) {
                                        $markVal = intval($mRow['marks']);
                                        $rank_s = intval($mRow['rank']) ?: 0;
                                        if ($rank_s > 0) {
                                            $sumThisPaper += round($markVal / $rank_s * 100);
                                            $countThisPaper++;
                                        }
                                    }
                                    if ($countThisPaper > 0) {
                                        $studentTotalPercent += round($sumThisPaper / $countThisPaper);
                                        $paperCount++;
                                    }
                                }
                            }
                            if ($paperCount > 0) $totalMarks[] = round($studentTotalPercent / $paperCount);
                        }
                        if (count($totalMarks) > 0) $classavg_display = round(array_sum($totalMarks) / count($totalMarks));
                    }
                }

                // Render row
                ?>
                <tr>
                    <td class="subject-name"><?php echo htmlspecialchars($subject); ?></td>
                    <td class="num"><?php echo ($cwmark !== null) ? $cwmark : ''; ?></td>
                    <td class="num"><?php echo ($exammark !== null) ? $exammark : ''; ?></td>
                    <td class="num"><?php echo ($finalmark !== null) ? $finalmark : 'N/A'; ?></td>
                    <td class="num"><?php echo htmlspecialchars($grade_label); ?></td>
                    <td class="num"><?php echo ($effort_display !== '') ? htmlspecialchars($effort_display) : ''; ?></td>
                    <td class="num"><?php echo ($classavg_display !== '') ? $classavg_display : ''; ?></td>
                </tr>
            <?php } // end while subjects ?>
            </tbody>
        </table>
    <?php else: ?>
        <div style="border:1px solid #000; padding:12px; margin-top:10px;">Oops!! No Marks Added Yet</div>
    <?php endif; ?>

    <!-- Grading legend (dynamic from DB or defaults) -->
    <table class="grading-table" aria-label="grading legend">
        <thead>
            <tr>
                <th class="grading-title" colspan="<?php echo max(1, count($grades)); ?>">Grading</th>
            </tr>
            <tr>
                <?php foreach ($grades as $g): ?>
                    <th><?php echo htmlspecialchars($g['label']); ?></th>
                <?php endforeach; ?>
            </tr>
        </thead>
        <tbody>
            <tr>
                <?php foreach ($grades as $g): ?>
                    <td><?php echo htmlspecialchars($g['range']); ?></td>
                <?php endforeach; ?>
            </tr>
        </tbody>
    </table>

    <!-- N/A note -->
    <div style="text-align:center; margin-top:8px; font-weight:700;">#N/A - Subject not taken or Subject not done. <br> Classwork - Tests/Homeworks/Assignments etc.</div>

    <!-- Effort box -->
    <div class="effort-box" role="note" aria-label="effort descriptions">
        <div style="font-weight:700; margin-bottom:6px; text-align:center;">Effort</div>
        <div>
            <?php
            $geteffort = sq($con, "SELECT * FROM effort_types WHERE status='1' ORDER BY rank ASC");
            while ($rowss = mysqli_fetch_array($geteffort)) {
                $effort_d = $rowss['description'];
                $rank = $rowss['rank'];
                echo '<div class="effort-row"><div style="width:40px;text-align:right;font-weight:700;">' . str_pad($rank, 2, ' ', STR_PAD_LEFT) . '</div><div style="flex:1;padding-left:8px;">' . htmlspecialchars($effort_d) . '</div></div>';
            }
            ?>
        </div>
    </div>

    <!-- Class teacher comments -->
    <div class="comments" id="teacher_comment" aria-labelledby="comments-heading">
        <h3 id="comments-heading">Class Tutor's Comments</h3>
        <div>
            <?php
            $getreports = sq($con, "SELECT * FROM subjecttermreports WHERE class_id='$class_id' AND term_id='$tm' AND student_id='$std' AND status=1 LIMIT 1");
            if (!$getreports || mysqli_num_rows($getreports) == 0) {
                echo '<p>No Comments</p>';
            } else {
                $r = mysqli_fetch_array($getreports);
                // Remove any HTML tags (including <p>, <span style=...>, etc.) then escape and preserve line breaks
                $cleanReport = strip_tags($r['report']);
                echo '<p>' . nl2br(htmlspecialchars($cleanReport)) . '</p>';
            }
            ?>
        </div>
    </div>

    <!-- Attendance -->
    <div style="display:flex; justify-content:center; gap:20px; margin-top:12px; align-items:center;">
        <table class="attendance" aria-label="attendance">
            <tbody>
                <tr>
                    <td>Total days in the Term</td>
                    <td style="text-align:center;"><?php echo intval($overall_days); ?></td>
                </tr>
                <tr>
                    <td>Number of days Late</td>
                    <td style="text-align:center;"><?php echo intval($present2); ?></td>
                </tr>
                <tr>
                    <td>Number of days Absent</td>
                    <td style="text-align:center;"><?php echo intval($absent); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- Signatures -->
    <div class="signatures" aria-label="signatures">
        <div class="sign-box">
            <div><strong>Principal :</strong> <?php echo htmlspecialchars($principalname); ?></div>
            <?php if (!empty($psign_ext) && !empty($staff_id3)): ?>
                <img alt="Principal signature" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id3) . '.' . $psign_ext ?>">
            <?php endif; ?>
        </div>
        <div class="sign-box" style="text-align:right;">
            <div><strong>Head Teacher :</strong> <?php echo htmlspecialchars($headteachername); ?></div>
            <?php if (!empty($hsign_ext) && !empty($staff_id2)): ?>
                <img alt="Head teacher signature" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id2) . '.' . $hsign_ext ?>">
            <?php endif; ?>
        </div>
    </div>

    <!-- Important Notice -->
    <div class="notice" aria-label="important notice">
        <h4>Important Notice!</h4>
        <p><?php echo !empty($notice) ? nl2br(htmlspecialchars($notice)) : 'No Important Notice'; ?></p>
    </div>

    <footer>
        &copy; <?php echo date('Y'); ?> The King's School — '...training today's students, equipping tomorrow's leaders'
    </footer>
</div>

<script>
    // print automatically in a popup (uncomment in production if you want auto-print)
    // window.print();
</script>
</body>
</html>