<?php
// Adam Khoury PHP Image Function Library 1.0
// -------------- RESIZE FUNCTION -------------
// Function for resizing any jpg, gif, or png image files
function ak_img_resize($target, $newcopy, $w, $h, $ext) {
    list($w_orig, $h_orig) = getimagesize($target);
    $scale_ratio = $w_orig / $h_orig;
    if (($w / $h) > $scale_ratio) {
           $w = $h * $scale_ratio;
    } else {
           $h = $w / $scale_ratio;
    }
    $img = false;
    $ext = strtolower($ext);
    $data = @file_get_contents($target);
    if ($ext == "gif"){
        if (function_exists('imagecreatefromgif')) $img = @imagecreatefromgif($target);
    } else if($ext =="png"){
        if (function_exists('imagecreatefrompng')) $img = @imagecreatefrompng($target);
    } else {
        if (function_exists('imagecreatefromjpeg')) $img = @imagecreatefromjpeg($target);
    }
    if (!$img && function_exists('imagecreatefromstring') && $data !== false) {
        $img = @imagecreatefromstring($data);
    }
    if (!$img) {
        // cannot process image on this environment
        return false;
    }
    $tci = imagecreatetruecolor($w, $h);
    if (in_array($ext, ['png','gif'])) {
        imagecolortransparent($tci, imagecolorallocatealpha($tci, 0, 0, 0, 127));
        imagealphablending($tci, false);
        imagesavealpha($tci, true);
    }
    // imagecopyresampled(dst_img, src_img, dst_x, dst_y, src_x, src_y, dst_w, dst_h, src_w, src_h)
    imagecopyresampled($tci, $img, 0, 0, 0, 0, $w, $h, $w_orig, $h_orig);
    $ok = false;
    if ($ext == "gif"){
        if (function_exists('imagegif')) $ok = imagegif($tci, $newcopy);
    } else if($ext =="png"){
        if (function_exists('imagepng')) $ok = imagepng($tci, $newcopy);
    } else {
        if (function_exists('imagejpeg')) $ok = imagejpeg($tci, $newcopy, 84);
    }
    @imagedestroy($tci);
    @imagedestroy($img);
    return (bool) $ok;
}
// ------------- THUMBNAIL (CROP) FUNCTION -------------
// Function for creating a true thumbnail cropping from any jpg, gif, or png image files
function ak_img_thumb($target, $newcopy, $w, $h, $ext) {
    list($w_orig, $h_orig) = getimagesize($target);
    $src_x = ($w_orig / 2) - ($w / 2);
    $src_y = ($h_orig / 2) - ($h / 2);
    $ext = strtolower($ext);
    $img = false;
    $data = @file_get_contents($target);
    if ($ext == "gif"){
        if (function_exists('imagecreatefromgif')) $img = @imagecreatefromgif($target);
    } else if($ext =="png"){
        if (function_exists('imagecreatefrompng')) $img = @imagecreatefrompng($target);
    } else {
        if (function_exists('imagecreatefromjpeg')) $img = @imagecreatefromjpeg($target);
    }
    if (!$img && function_exists('imagecreatefromstring') && $data !== false) {
        $img = @imagecreatefromstring($data);
    }
    if (!$img) {
        return false;
    }
    $tci = imagecreatetruecolor($w, $h);
    if (in_array($ext, ['png','gif'])) {
        imagecolortransparent($tci, imagecolorallocatealpha($tci, 0, 0, 0, 127));
        imagealphablending($tci, false);
        imagesavealpha($tci, true);
    }
    imagecopyresampled($tci, $img, 0, 0, $src_x, $src_y, $w, $h, $w, $h);
    $ok = false;
    if ($ext == "gif"){
        if (function_exists('imagegif')) $ok = imagegif($tci, $newcopy);
    } else if($ext =="png"){
        if (function_exists('imagepng')) $ok = imagepng($tci, $newcopy);
    } else {
        if (function_exists('imagejpeg')) $ok = imagejpeg($tci, $newcopy, 84);
    }
    @imagedestroy($tci);
    @imagedestroy($img);
    return (bool) $ok;
}
?> 