<?php
include '../includes/conn.php';
if (($_SESSION['schoolsyslevel'] != 4)) {
    header('Location:../login.php');
}
$std = $_GET['std'];
$tm = $_GET['tm'];

// Get student's class and class category ID
$student_query = mysqli_query($con, "SELECT class_id FROM students WHERE student_id = '$std'");
$student_data = mysqli_fetch_array($student_query);
$student_class_id = $student_data['class_id'];

// Get class category ID from the student's class
$class_query = mysqli_query($con, "SELECT category_id FROM classes WHERE class_id = '$student_class_id'");
$class_data = mysqli_fetch_array($class_query);
$classcategory_id = $class_data['category_id'];

// Get custom grades for this class category
$grades_query = mysqli_query($con, "SELECT * FROM grade_config WHERE classcategory_id = '$classcategory_id' ORDER BY grade_letter, grade_modifier");
$custom_grades = array();
while ($grade = mysqli_fetch_array($grades_query)) {
    $custom_grades[$grade['grade_letter'] . $grade['grade_modifier']] = $grade['mark_range'];
}

// Default grades if no custom grades are set
$default_grades = array(
    'A*' => '80-100',
    'A' => '70-79',
    'B' => '60-69',
    'C' => '50-59',
    'D' => '40-49',
    'E' => '25-39',
    'U' => '0-24'
);

// Use custom grades if available, otherwise use defaults
$grades = !empty($custom_grades) ? $custom_grades : $default_grades;
?>
<!DOCTYPE html>
<html>

<head>

    <style type="text/css" media="print">
        @page {
            size: auto;
            /* auto is the initial value */
            margin: 0;

            /* this affects the margin in the printer settings */

        }

        table {
            page-break-inside: avoid;
            border: solid black !important;
            border-width: 1px 0 0 1px !important;
        }

        tr,
        td {
            page-break-inside: avoid;
            border: solid black !important;
            border-width: 0 1px 1px 0 !important;
        }

        th,
        td {
            border: solid black !important;
            border-width: 0 1px 1px 0 !important;
        }

        .table-wrapper {
            padding-top: 20mm;
        }

        .table-container {
            display: flex;
            flex-wrap: wrap;
            /* justify-content: space-between; */
            /* margin-bottom: 30px; */
        }

        .table-container table {
            border-collapse: collapse;
            width: 50%;
            margin: 0 5px;
        }

        .table-container th,
        td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }

        .table-container th {
            background-color: lightgray;
        }
    </style>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Progress Report </title>
    <link href="<?php echo BASE_URL; ?>/assets/stylesheets/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/stylesheets/animate.css" rel="stylesheet">
    <link href="<?php echo BASE_URL; ?>/assets/stylesheets/style.css" rel="stylesheet">


    <script src="<?php echo BASE_URL; ?>/js/jquery-1.11.3.min.js"></script>

</head>
<?php
$getterm =  mysqli_query($con, "SELECT ft.*, fy.fyear FROM financialterms ft inner join financialyears fy ON ft.academic_year=fy.fyear_id WHERE ft.financialterm_id='$tm'");
$row4 =  mysqli_fetch_array($getterm);
$term2 = $row4['term'];
$year = $row4['year'];
$academic_year = $row4['fyear'];
$startdate_4 = $row4['startdate'];
$enddate_4 = $row4['enddate'];
$marks =  mysqli_query($con, "SELECT  * FROM marks WHERE  term_id='$tm' AND student_id='$std'");
$roww =  mysqli_fetch_array($marks);
$class_id = $roww['class_id'];
$com_class_id = $roww['class_id'];
$getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
$row2 =  mysqli_fetch_array($getclasses);
$class2 = $row2['class'];
$class3 = $row2['class'];
$report_type = $row2['report_type'];
$aveage_type = $row2['average_type'];
$category_id = $row2['category_id'];
$getcat =  mysqli_query($con, "SELECT * FROM classcategories WHERE classcategory_id='$category_id'") or die(mysqli_error($con));
$rowc =  mysqli_fetch_array($getcat);
$classcategory = $rowc['classcategory'];
$employee =  mysqli_query($con, "SELECT * FROM students WHERE student_id='$std'");
$rows = mysqli_fetch_array($employee);
$fullname = $rows['fullname'];
$student_id = $rows['student_id'];
// $getuser =  mysqli_query($con, "SELECT * FROM users WHERE cat_id='$category_id' AND status=1") or die(mysqli_error($con));
// $rowu = mysqli_fetch_array($getuser);
// $staff_id = $rowu['staff_id'];
// $getstaff =  mysqli_query($con, "SELECT * FROM staff  WHERE staff_id='$staff_id'") or die(mysqli_error($con));
// $rows =  mysqli_fetch_array($getstaff);
// $fullname1 = $rows['fullname'];

$getdirector =  mysqli_query($con, "SELECT * FROM users WHERE level=2 AND status=1") or die(mysqli_error($con));
$rowd = mysqli_fetch_array($getdirector);
$staff_id1 = $rowd['staff_id'];

$getstaff1 =  mysqli_query($con, "SELECT * FROM staff  WHERE staff_id='$staff_id1'") or die(mysqli_error($con));
$rows1 =  mysqli_fetch_array($getstaff1);
$fullname2 = $rows1['fullname'];

$headteacher = mysqli_query($con, "SELECT * FROM staff WHERE designation='Head Teacher' AND status=1");
$rowh = mysqli_fetch_array($headteacher);
$hsign_ext = $rowh['sign_ext'];
$staff_id2 = $rowh['staff_id'];
$headteachername = $rowh['fullname'];

$pteacher = mysqli_query($con, "SELECT * FROM staff WHERE designation='Principal' AND status=1");
$rowp = mysqli_fetch_array($pteacher);
$psign_ext = $rowp['sign_ext'];
$staff_id3 = $rowp['staff_id'];
$principalname = $rowp['fullname'];

$getstudents =  mysqli_query($con, "SELECT * FROM students WHERE status='1'");
$numtotalstudents = mysqli_num_rows($getstudents);
$getteacher =  mysqli_query($con, "SELECT * FROM teachers WHERE status=1 AND class_id='$class_id'");
$rowt = mysqli_fetch_array($getteacher);
$teachername = $rowt['fullname'];
?>

<body class="white-bg">
    <div class="wrapper wrapper-content p-xl">
        <div class="ibox-content p-xl">
            <div class="row" style="margin-bottom:30px;">

                <div style="float: left; margin-top: 10px; margin-left: 5px;">
                    <p style="margin: 0px; font-size: 20px; color:chartreuse; font-weight: bold;">Christian, English Speaking, International School</p>
                    <p style="margin: 0px; font-size: 15px; font-weight: bold;">P.O. BOX 1560, Bujumbura, Burundi</p>
                    <p style="margin: 0px; font-size: 15px; ">TEL: (+257) 22 27 96 78/69 84 04 78</p>
                    <p style="margin: 0px; font-size: 14px;">Email: secondary.school@thekingsschool.edu.bl</p>
                    <p style="margin: 0px; font-size: 14px;">Website: www.thekingsschool.edu.bl</p>
                </div>
                <!-- <div style="float: left; margin-top: 10px; margin-left: 20px;">
                    <p style="margin: 0px; font-size:15px; font-weight: bold;">REPORT FOR <span style="text-transform: uppercase;"><?php echo $classcategory; ?></span></p>
                    <p style="margin: 0px; font-size: 15px; font-weight: bold;">TERM: <?php echo $term2; ?></p>
                    <p style="margin: 0px; font-size: 15px; font-weight: bold;">TERM DATES: <?php echo date('d/M/y', $startdate_4) ?> to <?php echo date('d/M/y', $enddate_4); ?></p>
                    <p style="margin: 0px; font-size: 15px; font-weight: bold;">FORM TUTOR: <?php echo $teachername; ?></p>
                </div> -->
                <div style="float: right; margin-top: 10px; align-items: center;">
                    <img src=" <?php echo BASE_URL; ?>/images/schoollogo.JPG" style="width: 80px; height: 80px; margin-left: 20px; margin-bottom: 10px; ">
                    <p style="font-size: 12px; font-weight: 700;">ACADEMIC YEAR: <?php echo $academic_year; ?></p>
                </div>
            </div>

            <div>

                <?php if ($report_type != 1) { ?>
                    <?php
                    $classmarks =  mysqli_query($con, "SELECT  * FROM class_subjects WHERE class_id='$class_id' ");
                    if (mysqli_num_rows($classmarks) > 0) {
                    ?>
                        <table class="table  dataTables-example" style="margin-top: 30px; border: 2px solid #000;">
                            <thead>
                                <tr>
                                    <th class="row" colspan="7" style="border-bottom: 2px solid #000; background-color: #c6efce; ">
                                        <div class="col-sm-12" style=" text-align: center; font-size: 15px; font-weight: bold;  ">
                                            <p style="margin: 0px; font-size: 18px; font-weight: bold;">TERM <?php echo $term2; ?> REPORT - <?php echo date('M/Y', $enddate_4); ?> </p>

                                        </div>

                                    </th>
                                </tr>
                                <tr>
                                    <th class="row" colspan="7" style="border-bottom: 2px solid #000; ">
                                        <div class="col-sm-12" style=" text-align: center; font-size: 15px; font-weight: bold;  ">
                                            <p style="margin: 0px; font-size: 15px; font-weight: bold;">Student Name: <span style="text-decoration: underline;"><?php echo $fullname; ?></span>
                                                <span style="margin-left:20px; font-size: 15px; font-weight: bold; text-align: right;">Year: <span style="text-decoration: underline;"><?php
                                                                                                                                                                                        // strip year from class name
                                                                                                                                                                                        $class3 = explode(" ", $class2)[1];
                                                                                                                                                                                        echo $class3; ?></span></span>
                                            </p>
                                        </div>

                                    </th>
                                </tr>
                                <tr>
                                    <th rowspan="2" style="border: 2px solid #000;">Subjects</th>
                                    <!-- <th colspan="2" class="text-center">Assignments</th> -->
                                    <th colspan="4" class="text-center" style="border: 2px solid #000;"> Exam</th>
                                    <th rowspan="2" style="border: 2px solid #000;">Grade</th>
                                    <!-- <th rowspan="2">Exam Class Average</th> -->
                                    <th rowspan="2" style="border: 2px solid #000;">Class Average</th>
                                    <th rowspan="2" style="border: 2px solid #000;">Effort</th>
                                </tr>
                                <tr>

                                    <?php
                                    $getpapers =  mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                                    if (mysqli_num_rows($getpapers) > 0) {
                                        while ($rowp =  mysqli_fetch_array($getpapers)) {
                                            $paper_id = $rowp['paper_id'];
                                            $paper = $rowp['paper_name'];
                                    ?>
                                            <th><?php echo $paper ?></th>
                                    <?php
                                        }
                                    } ?>
                                    <!--<th>Tot</th>-->
                                    <th>%</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                while ($row =  mysqli_fetch_array($classmarks)) {
                                    $subject_id = $row['subject_id'];
                                    $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                                    $row3 =  mysqli_fetch_array($getsubjects);
                                    $subject = $row3['subject'];
                                    $subject_id = $row3['subject_id'];
                                    $checkmark__s =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND student_id='$std'  AND term_id='$tm' AND subject_id='$subject_id' AND assessment!='1' and status='1' limit 1");
                                    if (mysqli_num_rows($checkmark__s) > 0) {
                                        $rowss_eff =  mysqli_fetch_array($checkmark__s);
                                        $effort_id = $rowss_eff['effort_id'];
                                    } else {
                                        $effort_id = 0;
                                    }
                                    // get all papers
                                    $getpapers =  mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                                    $mark_null = [];
                                    $numpapers_2 = mysqli_num_rows($getpapers);
                                    if (mysqli_num_rows($getpapers) > 0) {
                                        // empty mark_null array for every subject
                                        // $mark_null = [];

                                        while ($rowp =  mysqli_fetch_array($getpapers)) {
                                            $paper_id = $rowp['paper_id'];
                                            $paper = $rowp['paper_name'];
                                            $checkmark_1 =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND student_id='$std'  AND term_id='$tm' AND subject_id='$subject_id' AND paper_id='$paper_id' AND assessment='2' and status='1'");
                                            if (mysqli_num_rows($checkmark_1) > 0) {
                                                $row2 =  mysqli_fetch_array($checkmark_1);
                                                $marks = $row2['marks'];
                                                if ($marks == 'N/A') {
                                                    array_push($mark_null, $marks);
                                                }
                                                // array_push($mark_null, $paper);
                                            } else {
                                                $marks = 'N/A';
                                                array_push($mark_null, $marks);
                                            }
                                        }
                                    }
                                ?>
                                    <tr class="gradeA" style="border: 2px solid #000;">
                                        <?php
                                        if (count($mark_null) >= 3) {
                                        } else { ?>

                                            <td style="border: 2px solid #000;"><?php echo $subject; ?></td>


                                            <!-- get exam marks for each paper -->
                                            <?php
                                            $getpapers =  mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                                            $total = 0;
                                            $grandtotal = 0;
                                            $mark = [];
                                            $numpapers = mysqli_num_rows($getpapers);
                                            if (mysqli_num_rows($getpapers) > 0) {
                                                while ($rowp =  mysqli_fetch_array($getpapers)) {
                                                    $paper_id = $rowp['paper_id'];
                                                    // echo $paper_id;
                                                    $paper = $rowp['paper_name'];
                                                    $getexam_s =  mysqli_query($con, "SELECT * FROM marks WHERE 
                                assessment ='2'AND class_id='$class_id'  AND term_id='$tm'  AND subject_id='$subject_id' and marks!='N/A'
                                                                                              AND student_id='$std'
                                 AND paper_id='$paper_id'and status='1'
                                 ");

                                                    if (mysqli_num_rows($getexam_s) > 0) {
                                                        $rowss =  mysqli_fetch_array($getexam_s);
                                                        $exammark1 = $rowss['marks'];
                                                        $rank = $rowss['rank'];
                                                        $exammark = round((intval($exammark1) / intval($rank)) * 100);
                                                        array_push($mark, $exammark);
                                                        $total += intval($exammark);
                                                    } else {
                                                        $total += 0;
                                                        $exammark = 'N/A';
                                                        array_push($mark, $exammark);
                                                        // $exammark = 0;
                                                    }
                                            ?>

                                                    <td style="border: 2px solid #000;"><?php echo $exammark; ?></td>

                                            <?php
                                                }
                                            } else {
                                                echo 'No papers set';
                                            }
                                            ?>
                                            <!--<td><?php echo $total; ?></td>-->
                                            <td style="border: 2px solid #000;"><?php
                                                                                // check if mark array has any N/A
                                                                                if (in_array('N/A', $mark)) {
                                                                                    // remove N/A from array
                                                                                    $mark = array_diff($mark, array('N/A'));
                                                                                    // get average of remaining marks
                                                                                    if (count($mark) > 0) {
                                                                                        $grandtotal = round(array_sum($mark) / count($mark));
                                                                                        echo $grandtotal;
                                                                                    } else {
                                                                                        $grandtotal = round($total / $numpapers);
                                                                                        echo $grandtotal;
                                                                                    }
                                                                                } else {
                                                                                    $grandtotal = round($total / $numpapers);
                                                                                    echo $grandtotal;
                                                                                }

                                                                                ?></td>

                                            <td style="border: 2px solid #000;">
                                                <?php
                                                if ($grandtotal == 'N/A') {
                                                    echo 'N/A';
                                                } else {
                                                    $grade_found = false;
                                                    foreach ($grades as $grade => $range) {
                                                        list($min, $max) = explode('-', $range);
                                                        if ($grandtotal >= $min && $grandtotal <= $max) {
                                                            echo $grade;
                                                            $grade_found = true;
                                                            break;
                                                        }
                                                    }
                                                    if (!$grade_found) {
                                                        echo 'U'; // Default to U if no grade range matches
                                                    }
                                                }
                                                ?>
                                            </td>
                                            <td style="border: 2px solid #000;">
                                                <!-- calculate class average -->
                                                <?php
                                                if ($aveage_type != 0) {

                                                    // get total number of students who follow the subject 

                                                    // Get total number of students who follow the subject
                                                    $getclassavg = mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1'");
                                                    $count = mysqli_num_rows($getclassavg);
                                                    if ($count > 0) {
                                                        $total = 0;
                                                        while ($row = mysqli_fetch_array($getclassavg)) {
                                                            $exammark1 = $row['marks'];
                                                            $rank = $row['rank'];
                                                            $exammark = round(intval($exammark1) / intval($rank) * 100);
                                                            $total += $exammark;
                                                        }
                                                        $classavg = round($total / $count);
                                                        echo $classavg;
                                                    } else {
                                                        echo '';
                                                    }
                                                } else {
                                                    // get student ids for all students that take this subject 
                                                    $getStudentsQuery = "SELECT student_id FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' and paper_id='1'";
                                                    $studentsResult = mysqli_query($con, $getStudentsQuery);
                                                    $totalStudents = mysqli_num_rows($studentsResult);
                                                    $totalMarks = [];
                                                    while ($studentRow = mysqli_fetch_assoc($studentsResult)) {
                                                        $studentId = $studentRow['student_id'];
                                                        // get papers for this subject
                                                        $getPapersQuery = "SELECT * FROM papers WHERE status='1'";
                                                        $papersResult = mysqli_query($con, $getPapersQuery);
                                                        $totalMarksForStudent = 0;
                                                        $paperCount = [];
                                                        while ($paperRow = mysqli_fetch_assoc($papersResult)) {
                                                            $paperId = $paperRow['paper_id'];
                                                            $getMarksQuery = "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND paper_id='$paperId' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' AND student_id='$studentId'";
                                                            $marksResult = mysqli_query($con, $getMarksQuery);
                                                            $marksCount = mysqli_num_rows($marksResult);
                                                            if ($marksCount > 0) {
                                                                $totalMarksForPaper = 0;
                                                                while ($markRow = mysqli_fetch_assoc($marksResult)) {
                                                                    $mark = intval($markRow['marks']);
                                                                    $rank = intval($markRow['rank']);
                                                                    $totalMarksForPaper += round($mark / $rank * 100);
                                                                }
                                                                $paperCount[] = $paperId;
                                                                $totalMarksForStudent += round($totalMarksForPaper / $marksCount);
                                                            } else {
                                                                $totalMarksForStudent += 0;
                                                            }
                                                        }

                                                        $totalMarks[] = round($totalMarksForStudent / count($paperCount));
                                                    }
                                                    // print_r($totalMarks);
                                                    if ($totalStudents > 0) {
                                                        $classavg = round(array_sum($totalMarks) / $totalStudents);
                                                        echo $classavg;
                                                    } else {
                                                        echo '';
                                                    }
                                                }
                                                ?>
                                            </td>
                                            <td style="border: 2px solid #000;">
                                                <?php
                                                if ($effort_id != 0 || $effort_id != '0') {
                                                    $geteffort =  mysqli_query($con, "SELECT * FROM effort_types WHERE effort_id='$effort_id'");
                                                    $rowss =  mysqli_fetch_array($geteffort);
                                                    if (mysqli_num_rows($geteffort) > 0) {
                                                        $effort = $rowss['rank'];
                                                        echo $effort;
                                                    } else {
                                                        echo ' ';
                                                    }
                                                    // $effort = $rowss['rank'];
                                                    // echo $effort_id;
                                                }
                                                ?>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    <?php } else { ?>
                        <div class="alert alert-danger">Oops!! No Marks Added Yet</div>
                    <?php } ?>
                    <?php } else {
                    $marks =  mysqli_query($con, "SELECT  * FROM class_subjects WHERE class_id='$class_id'");
                    if (mysqli_num_rows($marks) > 0) {
                    ?>
                        <table class="table " style="margin-top: 30px; border: 2px solid #000;">
                            <thead>
                                <tr>
                                    <th class="row" colspan="7" style="border-bottom: 2px solid #000; background-color: #c6efce; ">
                                        <div class="col-sm-12" style=" text-align: center; font-size: 15px; font-weight: bold;  ">
                                            <p style="margin: 0px; font-size: 18px; font-weight: bold;">TERM <?php echo $term2; ?> REPORT - <?php echo date('M/Y', $enddate_4); ?> </p>

                                        </div>

                                    </th>
                                </tr>
                                <tr>
                                    <th class="row" colspan="7" style="border-bottom: 2px solid #000; ">
                                        <div class="col-sm-12" style=" text-align: center; font-size: 15px; font-weight: bold;  ">
                                            <p style="margin: 0px; font-size: 15px; font-weight: bold;">Student Name: <span style="text-decoration: underline;"><?php echo $fullname; ?></span>
                                                <span style="margin-left:20px; font-size: 15px; font-weight: bold; text-align: right;">Year: <span style="text-decoration: underline;"><?php
                                                                                                                                                                                        // strip year from class name
                                                                                                                                                                                        $class3 = explode(" ", $class2)[1];
                                                                                                                                                                                        echo $class3; ?></span></span>
                                            </p>
                                        </div>

                                    </th>
                                </tr>
                                <tr style="background-color: aqua; border-bottom: 2px solid #000;">
                                    <th style="border: 2px solid #000;">Subject</th>
                                    <th style="border: 2px solid #000;">Class Work /40</th>
                                    <th style="border: 2px solid #000;">Exam /60</th>
                                    <th style="border: 2px solid #000;">Cummulative %</th>
                                    <th style="border: 2px solid #000;">Grade</th>
                                    <th style="border: 2px solid #000;">Effort</th>
                                    <th style="border: 2px solid #000;">Class Average</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                while ($row =  mysqli_fetch_array($marks)) {
                                    $subject_id = $row['subject_id'];
                                    $getsubjects =  mysqli_query($con, "SELECT * FROM subjects WHERE subject_id='$subject_id'");
                                    $row3 =  mysqli_fetch_array($getsubjects);
                                    $subject = $row3['subject'];
                                    $subject_id = $row3['subject_id'];
                                    $mark_null = [];
                                    $getexam_2 =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND student_id='$std'  AND term_id='$tm' AND subject_id='$subject_id' AND assessment='2'and status='1'");
                                    if (mysqli_num_rows($getexam_2) > 0) {
                                        $rowss =  mysqli_fetch_array($getexam_2);
                                        $exammark_2 = $rowss['marks'];
                                        if ($exammark_2 == 'N/A') {
                                            array_push($mark_null, $exammark_2);
                                        }
                                    } else {
                                        array_push($mark_null, 'N/A');
                                    }
                                ?>
                                    <tr style="border: 2px solid #000;">
                                        <?php
                                        if (count($mark_null) >= 1) {
                                        } else { ?>
                                            <!-- subject name -->
                                            <td style="border: 2px solid #000;"><?php echo $subject; ?></td>
                                            <!-- classwork /40 -->
                                            <td style="border: 2px solid #000;">
                                                <?php
                                                $getcw =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND student_id='$std'  AND term_id='$tm' AND subject_id='$subject_id' AND assessment='1'and status='1'");
                                                if (mysqli_num_rows($getcw) > 0) {
                                                    $rowss =  mysqli_fetch_array($getcw);
                                                    $cwmark = $rowss['marks'];
                                                    $rank = $rowss['rank'];
                                                    // Calculate classwork mark out of 40
                                                    $cwmark_percent = round((intval($cwmark) / intval($rank)) * 40);
                                                    echo $cwmark_percent;
                                                } else {
                                                    echo ' ';
                                                    $cwmark_percent = 0;
                                                }
                                                ?>
                                            </td>
                                            <!-- exam /60 -->
                                            <td style="border: 2px solid #000;">
                                                <?php
                                                $getexam =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND student_id='$std'  AND term_id='$tm' AND subject_id='$subject_id' AND assessment='2'and status='1'");
                                                if (mysqli_num_rows($getexam) > 0) {
                                                    $rowss =  mysqli_fetch_array($getexam);
                                                    $exammark = $rowss['marks'];
                                                    $rank = $rowss['rank'];
                                                    $effort_id = $rowss['effort_id'];
                                                    // Calculate exam mark out of 60
                                                    $exammark_percent = round((intval($exammark) / intval($rank)) * 60);
                                                    echo $exammark_percent;
                                                } else {
                                                    $exammark = 'N/A';
                                                    $exammark_percent = 0;
                                                    echo ' ';
                                                }
                                                ?>
                                            </td>
                                            <!-- cummulative %-->
                                            <td style="border: 2px solid #000;">
                                                <?php
                                                $finalmark = $cwmark_percent + $exammark_percent;
                                                echo $finalmark;
                                                ?>
                                            </td>
                                            <!-- grade -->
                                            <td style="border: 2px solid #000;">
                                                <?php
                                                if ($finalmark == 'N/A') {
                                                    echo 'N/A';
                                                } else {
                                                    $grade_found = false;
                                                    foreach ($grades as $grade => $range) {
                                                        list($min, $max) = explode('-', $range);
                                                        if ($finalmark >= $min && $finalmark <= $max) {
                                                            echo $grade;
                                                            $grade_found = true;
                                                            break;
                                                        }
                                                    }
                                                    if (!$grade_found) {
                                                        echo 'U'; // Default to U if no grade range matches
                                                    }
                                                }
                                                ?>
                                            </td>

                                            <td style="border: 2px solid #000;">
                                                <?php
                                                if ($effort_id != 0 || $effort_id != null) {
                                                    $geteffort =  mysqli_query($con, "SELECT * FROM effort_types WHERE effort_id='$effort_id'");
                                                    $rowss =  mysqli_fetch_array($geteffort);
                                                    $effort = $rowss['rank'];
                                                    echo $effort;
                                                }
                                                ?>
                                            </td>
                                            <td style="border: 2px solid #000;">
                                                <!-- calculate class average -->
                                                <?php
                                                if ($aveage_type != 0) {
                                                    // get total number of students who follow the subject 
                                                    $getclassavg =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' and marks!='N/A' AND subject_id='$subject_id'AND term_id='$tm' AND assessment='2'and status='1'  ");
                                                    if (mysqli_num_rows($getclassavg) > 0) {
                                                        $total = 0;
                                                        $count = 0;
                                                        while ($rowss =  mysqli_fetch_array($getclassavg)) {
                                                            $exammark1 = $rowss['marks'];
                                                            $rank = $rowss['rank'];
                                                            $finalmark = round(intval($finalmark) / intval($rank) * 100);
                                                            $total += $exammark;
                                                            $count++;
                                                        }
                                                        // echo $total;
                                                        // echo '<br/>';
                                                        // echo $count;
                                                        // echo '<br/>';
                                                        $classavg = round($total / $count);
                                                        echo $classavg;
                                                    } else {
                                                        echo 'N/A';
                                                    }
                                                } else {
                                                    // Get total number of students who follow the subject
                                                    $getPapers = mysqli_query($con, "SELECT * FROM papers WHERE status='1'");
                                                    $total_marks = [];
                                                    while ($row = mysqli_fetch_array($getPapers)) {
                                                        $papers_id = $row['paper_id'];
                                                        $getMarks = mysqli_query($con, "SELECT marks, rank FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND paper_id='$papers_id' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !=''");
                                                        $marksCount = mysqli_num_rows($getMarks);
                                                        if ($marksCount > 0) {
                                                            $totalMarks = 0;
                                                            while ($marksRow = mysqli_fetch_array($getMarks)) {
                                                                $mark = $marksRow['marks'];
                                                                $rank_s = $marksRow['rank'];
                                                                $totalMarks += round(intval($mark) / intval($rank_s) * 100);
                                                            }
                                                            array_push($total_marks, $totalMarks);
                                                        }
                                                    }
                                                    if (count($total_marks) > 0) {
                                                        $grand_total = round(array_sum($total_marks) / count($total_marks));
                                                        $getclass_avg =  mysqli_query($con, "SELECT * FROM marks WHERE class_id='$class_id' AND subject_id='$subject_id' AND term_id='$tm' AND assessment='2' AND status='1' AND marks != 'N/A' AND marks !='' and paper_id='1'");
                                                        $count = mysqli_num_rows($getclass_avg);
                                                        if ($count > 0) {
                                                            $classAvg = round($grand_total / $count);
                                                            echo $classAvg;
                                                        } else {
                                                            echo '';
                                                        }
                                                    } else {
                                                        echo '';
                                                    }
                                                }
                                                ?>
                                            </td>
                                        <?php } ?>
                                    </tr>
                                <?php } ?>

                            </tbody>
                        </table>
                    <?php } else { ?>
                        <div class="alert alert-danger">Oops!! No Marks Added Yet</div>

                <?php
                    }
                } ?>
                <div class="">
                    <!-- add table showing grading -->
                    <table class="table" style="border: 2px solid #000;">
                        <thead>
                            <tr style="background-color: #c6efce; border: 2px solid #000;">
                                <th colspan="<?php echo count($grades); ?>" style="text-align: center; border-bottom: 2px solid #000;">Grading</th>
                            </tr>
                            <tr style="border: 2px solid #000;">
                                <?php foreach ($grades as $grade => $range): ?>
                                    <th style="border: 2px solid #000;"><?php echo $grade; ?></th>
                                <?php endforeach; ?>
                            </tr>
                        </thead>
                        <tbody>
                            <tr style="border: 2px solid #000;">
                                <?php foreach ($grades as $grade => $range): ?>
                                    <td style="border: 2px solid #000;"><?php echo $range; ?></td>
                                <?php endforeach; ?>
                            </tr>
                        </tbody>
                    </table>
                    <div class="row mt-4">
                        <div class="col-sm-12" style=" text-align: center; font-size: 15px; font-weight: bold; padding: 5px 0px 5px 0px; ">
                            <p style="margin: 0px; font-size: 15px; font-weight: bold;">#N/A - Subject not taken or Subject not done </p>
                            <p style="margin: 0px; font-size: 15px; font-weight: bold;">Classwork - Tests/Homeworks/Assignment </p>

                        </div>

                    </div>
                    <!-- add table to show effort scale  -->
                    <table class="table " style="width:500px !important; ">
                        <thead>
                            <tr style="background-color:#c6efce; border: 2px solid #000;">
                                <th colspan="2" style="text-align: center; border-bottom: 2px solid #000; ">Effort</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $geteffort =  mysqli_query($con, "SELECT * FROM effort_types where status='1' ORDER BY rank ASC");
                            while ($rowss =  mysqli_fetch_array($geteffort)) {
                                $effort_d = $rowss['description'];
                                $rank = $rowss['rank'];
                            ?>
                                <tr style="border: 2px solid #000;">
                                    <td style="border: 2px solid #000; padding: 0px 25px; text-align: right;"><?php echo str_pad($rank, 2, ' ', STR_PAD_LEFT); ?></td>
                                    <td style="border: 2px solid #000;"><?php echo $effort_d; ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                        <!-- footer section -->
                        <tfoot>
                            <!-- <tr>
                    <td colspan="2">Effort is based on the following:</td>
                </tr> -->
                            <tr>
                                <td colspan="2">N/A - Subject not taken or Subject not done</td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
                <div class="">
                    <table class="table " id="teacher_comment" style="border: 2px solid #000; width: 100%;">
                        <thead>
                            <tr style="background-color: #c6efce;">
                                <th style="text-align: center; border-bottom: 2px solid #000; "> Class Teacher's Comments</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $getreports =  mysqli_query($con, "SELECT * FROM subjecttermreports WHERE class_id='$com_class_id' AND term_id='$tm' AND student_id='$std' AND status=1") or die(mysqli_error($con));
                            if (mysqli_num_rows($getreports) == 0) {
                                echo '<tr><td colspan="2">No Comments</td></tr>';
                            } else {
                                $row = mysqli_fetch_array($getreports);
                                $subjecttermreport_id = $row['subjecttermreport_id'];
                                $class_id = $row['class_id'];
                                // $topics = $row['topics'];
                                $report = $row['report'];
                                $timestamp = $row['timestamp'];
                                // $subject_id = $row['subject_id'];
                                $teacher_id = $row['teacher_id'];
                                $term_id = $row['term_id'];
                                $getclasses =  mysqli_query($con, "SELECT * FROM classes WHERE class_id='$class_id'");
                                $row2 =  mysqli_fetch_array($getclasses);
                                $class2 = $row2['class'];
                                $category_id = $row2['category_id'];
                                $name =  mysqli_query($con, "SELECT * FROM teachers WHERE teacher_id='$teacher_id'");
                                $roww =  mysqli_fetch_array($name);
                                $fname = $roww['fullname'];
                                $getterm =  mysqli_query($con, "SELECT  * FROM financialterms WHERE financialterm_id='$term_id'");
                                $row4 =  mysqli_fetch_array($getterm);
                                $term2 = $row4['term'];
                                $year = $row4['year'];
                                $notice = $row4['important_notice'];

                            ?>
                                <tr>
                                    <td>
                                        <div>

                                            <?php echo $report; ?>
                                        </div>
                                    </td>
                                </tr>
                            <?php }  ?>
                        </tbody>
                    </table>
                </div>
                <div class="" style="display: flex; align-items: center; justify-content: center;">
                    <table class=" table  table-responsive " style="border: 2px solid #000; width: 300px;">
                        <thead>
                            <!-- <tr>
            <th colspan="2">Attendance</th>
        </tr> -->
                        <tbody>
                            <?php
                            $getabsence =  mysqli_query($con, "SELECT * FROM attendance WHERE term_id='$tm' and class_id='$class_id' ") or die(mysqli_error($con));
                            $absent = 0;
                            $overall = 0;
                            $present = 0;
                            $present2 = 0;
                            while ($rowt = mysqli_fetch_array($getabsence)) {
                                $attendance_id = $rowt['attendance_id'];
                                $unjustified = 0;
                                $justified = 0;
                                $getabsence2 =  mysqli_query($con, "SELECT * FROM attendancedetails WHERE  status=0 AND student_id='$std' and attendance_id='$attendance_id'") or die(mysqli_error($con));
                                $getpresent =  mysqli_query($con, "SELECT * FROM attendancedetails WHERE  status=1 AND student_id='$std'and attendance_id='$attendance_id'") or die(mysqli_error($con));
                                $getpresent2 =  mysqli_query($con, "SELECT * FROM attendancedetails WHERE  status=2 AND student_id='$std'and attendance_id='$attendance_id'") or die(mysqli_error($con));
                                if (mysqli_num_rows($getabsence2) > 0) {
                                    while ($rowa =  mysqli_fetch_array($getabsence2)) {
                                        $absent++;
                                    }
                                }
                                if (mysqli_num_rows($getpresent) > 0) {
                                    while ($rowap =  mysqli_fetch_array($getpresent)) {
                                        $present++;
                                    }
                                }
                                if (mysqli_num_rows($getpresent2) > 0) {
                                    while ($rowpp =  mysqli_fetch_array($getpresent2)) {
                                        $present2++;
                                    }
                                }
                            }
                            $overall = $absent + $present + $present2;
                            ?>
                            <tr style="border: 2px solid #000;">
                                <td style="border: 2px solid #000;">
                                    Total days in the Term
                                </td>
                                <td style="border: 2px solid #000;">
                                    <?php echo $overall; ?>
                                </td>
                            </tr>
                            <tr style="border: 2px solid #000;">
                                <td style="border: 2px solid #000;">
                                     Number of days Late
                                </td>
                                <td style="border: 2px solid #000;">
                                    <?php echo $present2; ?>
                                </td>
                            </tr>
                            <tr style="border: 2px solid #000;">
                                <td style="border: 2px solid #000;">
                                    Number of days Absent
                                </td>
                                <td style="border: 2px solid #000;">
                                    <?php echo $absent; ?>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
                <!-- section for Prinical and Head teacher Signature -->
                <h3 class="text-center mt-3">Signed By:</h3>
                <div class="row table-container" style="display: flex; justify-content: space-evenly;">
                    <div class="col-sm-4">
                        <label> <strong>Principal :</strong> <?php echo $principalname; ?> </label>
                        <p>

                            <strong>Principal Signature : </strong><img alt="image" style="width:80px" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id3) . '.' . $psign_ext ?>" width="100%">
                        </p>

                    </div>
                    <div class="col-sm-4">
                        <label> <strong>Head Teacher :</strong> <?php echo $headteachername; ?> </label>
                        <p><strong>Head Teacher Signature :</strong><img alt="image" style="width:80px" src="<?php echo BASE_URL; ?>/images/nonteaching/<?php echo md5($staff_id2) . '.' . $hsign_ext ?>" width="100%"></p>

                    </div>
                </div>
                <div class="col-lg-12" style="display: flex; justify-content: center; align-items: center;">
                    <table class="table" id="important_notice" style="border: 2px solid #000; width: 100%;">
                        <thead>
                            <tr>
                                <th style="text-align: center; border-bottom: 2px solid #000; background-color: #c6efce; ">Important Notice!</th>
                            </tr>
                        </thead>
                        <tbody>

                            <tr>
                                <td>
                                    <?php
                                    if ($notice != '') {
                                        echo $notice;
                                    } else {
                                        echo '<tr><td>No Important Notice</td></tr>';
                                    }
                                    ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>


            </div><!-- /table-responsive -->



            <div class="well m-t">
                <!-- <strong style="font-style: italic">Bujumbura International Montessori School.The World of Children</strong> -->
            </div>
        </div>

    </div>

    <!-- Mainly scripts -->
    <script src="<?php echo BASE_URL; ?>/js/jquery-1.10.2.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/bootstrap.min.js"></script>
    <script src="<?php echo BASE_URL; ?>/js/plugins/metisMenu/jquery.metisMenu.js"></script>

    <!-- Custom and plugin javascript -->
    <script src="<?php echo BASE_URL; ?>/js/inspinia.js"></script>

    <script type="text/javascript">
        window.print();
    </script>

</body>

</html>