<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys']) || (($_SESSION['schoolsyslevel'] != 1) && ($_SESSION['schoolsyslevel'] != 2))) {
    header('Location: login');
    exit;
}

// CSRF
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrf_token = $_SESSION['csrf_token'];

$msg = '';
$errors = [];

// Helper to validate mark range text like "90 - 100" and return [min,max]
function parse_mark_range($text) {
    $text = trim($text);
    if (preg_match('/^(\d{1,3})\s*-\s*(\d{1,3})$/', $text, $m)) {
        $min = (int)$m[1];
        $max = (int)$m[2];
        if ($min <= $max && $min >= 0 && $max <= 100) return [$min, $max];
    }
    return false;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf_mismatch = false;
    if (empty($_POST['csrf_token']) || $_POST['csrf_token'] !== ($_SESSION['csrf_token'] ?? '')) {
        $csrf_mismatch = true;
        // Friendly message and preserve posted data below
        $errors[] = 'Invalid request (CSRF). Your session may have expired or you opened the form in another tab. Your unsaved changes are shown below — please review and submit again.';
    }

    $classcategory_id = isset($_POST['classcategory_id']) ? (int)$_POST['classcategory_id'] : 0; // 0 for Default

    if (empty($errors)) {
        // Delete existing grade_config for this category
        $del = mysqli_prepare($con, 'DELETE FROM grade_config WHERE classcategory_id=?');
        if ($del) { mysqli_stmt_bind_param($del, 'i', $classcategory_id); mysqli_stmt_execute($del); mysqli_stmt_close($del); }

        // Insert new grade rows from posted arrays
        if (isset($_POST['grade_letter']) && is_array($_POST['grade_letter'])) {
            $ins = mysqli_prepare($con, 'INSERT INTO grade_config(classcategory_id, grade_letter, grade_modifier, mark_range, created_at) VALUES (?, ?, ?, ?, NOW())');
            foreach ($_POST['grade_letter'] as $k => $letter) {
                $letter = trim((string)$letter);
                $modifier = isset($_POST['grade_modifier'][$k]) ? trim((string)$_POST['grade_modifier'][$k]) : '';
                $mark_range = isset($_POST['mark_range'][$k]) ? trim((string)$_POST['mark_range'][$k]) : '';
                if ($letter === '' || $mark_range === '') continue;
                if (!parse_mark_range($mark_range)) {
                    $errors[] = 'Invalid mark range format for ' . htmlspecialchars($letter . $modifier) . '. Use e.g. 90 - 100';
                    continue;
                }
                if ($ins) {
                    mysqli_stmt_bind_param($ins, 'isss', $classcategory_id, $letter, $modifier, $mark_range);
                    mysqli_stmt_execute($ins);
                }
            }
            if ($ins) mysqli_stmt_close($ins);
        }

        if (empty($errors)) {
            $msg = 'Grading scale saved.';
            // rotate token
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
            $csrf_token = $_SESSION['csrf_token'];
        }
    }
}

// If we had a CSRF mismatch but the user posted grade rows, preserve them so they don't lose input
if (!empty($csrf_mismatch) && !empty($_POST) && isset($_POST['grade_letter']) && is_array($_POST['grade_letter'])) {
    $grades = [];
    foreach ($_POST['grade_letter'] as $k => $letter) {
        $letter = trim((string)$letter);
        $modifier = isset($_POST['grade_modifier'][$k]) ? trim((string)$_POST['grade_modifier'][$k]) : '';
        $mark_range = isset($_POST['mark_range'][$k]) ? trim((string)$_POST['mark_range'][$k]) : '';
        $grades[] = ['grade_letter' => $letter, 'grade_modifier' => $modifier, 'mark_range' => $mark_range];
    }
}

// Fetch categories (include Default with id 0)
$categories = [];
$categories[] = ['classcategory_id' => 0, 'classcategory' => 'Default'];
$cr = mysqli_query($con, "SELECT classcategory_id, classcategory FROM classcategories WHERE status=1 ORDER BY classcategory");
if ($cr) while ($r = mysqli_fetch_assoc($cr)) $categories[] = $r;

// load current selected category grading
$selected = isset($_GET['category']) ? (int)$_GET['category'] : 0;
$grades = [];
$gq = mysqli_prepare($con, 'SELECT grade_letter, grade_modifier, mark_range FROM grade_config WHERE classcategory_id = ? ORDER BY grade_letter, grade_modifier');
if ($gq) {
    mysqli_stmt_bind_param($gq, 'i', $selected);
    mysqli_stmt_execute($gq);
    $res = mysqli_stmt_get_result($gq);
    if ($res) {
        while ($row = mysqli_fetch_assoc($res)) $grades[] = $row;
    }
    mysqli_stmt_close($gq);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Grading Scales</title>
    <link href="css/style.css" rel="stylesheet">
    <link href="css/style-responsive.css" rel="stylesheet">
</head>
<body class="sticky-header">
<section>
    <?php include 'includes/header.php'; ?>
    <section class="wrapper">
        <div class="row">
            <div class="col-lg-12">
                <section class="panel">
                    <header class="panel-heading">Manage Grading Scales</header>
                    <div class="panel-body">
                        <?php if ($msg): ?><div class="alert alert-success"><?php echo htmlspecialchars($msg); ?></div><?php endif; ?>
                        <?php if (!empty($errors)): ?><div class="alert alert-danger"><?php echo implode('<br>', array_map('htmlspecialchars', $errors)); ?></div><?php endif; ?>

                        <form method="get" class="form-inline" style="margin-bottom:15px;">
                            <label>Select category: </label>
                            <select name="category" class="form-control" onchange="this.form.submit()">
                                <?php foreach ($categories as $c): ?>
                                    <option value="<?php echo $c['classcategory_id']; ?>" <?php echo ($selected == $c['classcategory_id'])? 'selected' : ''; ?>><?php echo htmlspecialchars($c['classcategory']); ?></option>
                                <?php endforeach; ?>
                            </select>
                        </form>

                        <form method="post" id="scale_form">
                            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                            <input type="hidden" name="classcategory_id" value="<?php echo htmlspecialchars($selected); ?>">

                            <div id="grade_rows">
                                <?php if (count($grades) > 0):
                                    foreach ($grades as $g): ?>
                                        <div class="row grade-row" style="margin-bottom:8px;">
                                            <div class="col-lg-3">
                                                <select name="grade_letter[]" class="form-control" required>
                                                    <option value="">Select Letter</option>
                                                    <?php foreach (['A','B','C','D','E','F','G'] as $L): ?>
                                                        <option value="<?php echo $L; ?>" <?php echo ($g['grade_letter']==$L)? 'selected':''; ?>><?php echo $L; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-lg-2">
                                                <select name="grade_modifier[]" class="form-control">
                                                    <option value="">None</option>
                                                    <option value="+" <?php echo ($g['grade_modifier']=='+')? 'selected':''; ?>>+</option>
                                                    <option value="-" <?php echo ($g['grade_modifier']=='-')? 'selected':''; ?>>-</option>
                                                    <option value="*" <?php echo ($g['grade_modifier']=='*')? 'selected':''; ?>>*</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-4">
                                                <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" value="<?php echo htmlspecialchars($g['mark_range']); ?>" required>
                                            </div>
                                            <div class="col-lg-3">
                                                <button class="btn btn-danger remove-row">Remove</button>
                                            </div>
                                        </div>
                                    <?php endforeach; else: ?>
                                        <!-- Empty: show one blank row by default -->
                                        <div class="row grade-row" style="margin-bottom:8px;">
                                            <div class="col-lg-3">
                                                <select name="grade_letter[]" class="form-control" required>
                                                    <option value="">Select Letter</option>
                                                    <?php foreach (['A','B','C','D','E','F','G'] as $L): ?>
                                                        <option value="<?php echo $L; ?>"><?php echo $L; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                            <div class="col-lg-2">
                                                <select name="grade_modifier[]" class="form-control">
                                                    <option value="">None</option>
                                                    <option value="+">+</option>
                                                    <option value="-">-</option>
                                                    <option value="*">*</option>
                                                </select>
                                            </div>
                                            <div class="col-lg-4">
                                                <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" required>
                                            </div>
                                            <div class="col-lg-3">
                                                <button class="btn btn-danger remove-row">Remove</button>
                                            </div>
                                        </div>
                                <?php endif; ?>
                            </div>

                            <div style="margin-top:10px;">
                                <button type="button" id="add_row" class="btn btn-success">Add Grade Row</button>
                                <button type="submit" class="btn btn-primary">Save Scale</button>
                            </div>
                        </form>

                        <hr>
                        <h4>Notes</h4>
                        <p>Define grade letters, optional modifiers (+, -, *) and the mark ranges (0 - 100). Choose "Default" to apply to categories that do not have their own scale.</p>

                    </div>
                </section>
            </div>
        </div>
    </section>
</section>

<script src="js/jquery-1.10.2.min.js"></script>
<script>
    $(function(){
        $('#add_row').on('click', function(e){
            e.preventDefault();
            var row = `
                <div class="row grade-row" style="margin-bottom:8px;">
                    <div class="col-lg-3">
                        <select name="grade_letter[]" class="form-control" required>
                            <option value="">Select Letter</option>
                            <?php foreach (array('A','B','C','D','E','F','G') as $_L): ?>
                                <option value="<?php echo $_L; ?>"><?php echo $_L; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-lg-2">
                        <select name="grade_modifier[]" class="form-control">
                            <option value="">None</option>
                            <option value="+">+</option>
                            <option value="-">-</option>
                            <option value="*">*</option>
                        </select>
                    </div>
                    <div class="col-lg-4">
                        <input type="text" name="mark_range[]" class="form-control" placeholder="e.g. 90 - 100" required>
                    </div>
                    <div class="col-lg-3">
                        <button class="btn btn-danger remove-row">Remove</button>
                    </div>
                </div>`;
            $('#grade_rows').append(row);
        });

        $(document).on('click', '.remove-row', function(e){
            e.preventDefault();
            $(this).closest('.grade-row').remove();
        });
    });
</script>
</body>
</html>