<?php
include 'includes/conn.php';
if (!isset($_SESSION['schoolsys'])) {
  header('Location:login');
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">
  <meta name="description" content="">
  <meta name="author" content="t">
  <link rel="shortcut icon" href="#" type="image/png">
  <title>Add Staff</title>
  <script src="js/jquery-1.10.2.min.js"></script>
  <script src="js/jquery-ui-1.9.2.custom.min.js"></script>
  <script src="js/jquery-migrate-1.2.1.min.js"></script>
  <script src="js/ckeditor/ckeditor.js"></script>
  <link rel="stylesheet" href="js/ckeditor/samples/sample.css">
  <link href="css/style.css" rel="stylesheet">
  <link href="css/chosen/chosen.css" rel="stylesheet">
  <link href="css/style-responsive.css" rel="stylesheet">

  <!-- HTML5 shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!--[if lt IE 9]>
  <script src="js/html5shiv.js"></script>
  <script src="js/respond.min.js"></script>
  <![endif]-->
</head>

<body class="sticky-header">
  <section>
    <?php include 'includes/header.php';
    //   echo str_replace('\', ' ',$organisation);
    ?>

    <section class="wrapper">
      <!-- page start-->

      <div class="row">
        <div class="col-lg-8">
          <section class="panel">
            <header class="panel-heading">
              Add New Staff
            </header>
            <div class="panel-body">
              <?php
              if (isset($_POST['fullname'], $_POST['gender'], $_POST['phone'], $_FILES['image'], $_POST['designation'], $_POST['email'], $_POST['username'], $_POST['password'], $_POST['email'], $_POST['role'])) {
                $image_name = $_FILES['image']['name'];
                $image_size = $_FILES['image']['size'];
                $image_temp = $_FILES['image']['tmp_name'];
                $allowed_ext = array('jpg', 'jpeg', 'png', 'PNG', 'gif', 'JPG', 'PNG', 'GIF', 'JPEG', '');
                $imgext = explode('.', $image_name);
                $image_ext = end($imgext);
                $fullname = mysqli_real_escape_string($con, trim($_POST['fullname']));
                $gender = $_POST['gender'];
                $phone = mysqli_real_escape_string($con, trim($_POST['phone']));
                $email = mysqli_real_escape_string($con, trim($_POST['email']));
                $designation = mysqli_real_escape_string($con, trim($_POST['designation']));
                $username = mysqli_real_escape_string($con, trim($_POST['username']));
                $password = mysqli_real_escape_string($con, trim($_POST['password']));
                $repeat = mysqli_real_escape_string($con, trim($_POST['repeat']));
                $role = $_POST['role'];
                $category = $_POST['category'];
                if (!empty($email)) {
                  $check = mysqli_query($con, "SELECT * FROM staff WHERE email='$email' AND status=1");
                  if (mysqli_num_rows($check) > 0) {
                    $errors[] = 'Email Already Exists';
                  }
                }
                if (!empty($username)) {
                  if ($role == 4) {
                    if (empty($category)) {
                      $errors[] = 'Select Category to Proceed';
                    }
                  }
                  if ((empty($role)) || (empty($password)) || (empty($repeat))) {
                    $errors[] = 'Some Fields are empty';
                  }
                }
                if (in_array($image_ext, $allowed_ext) === false) {
                  $errors[] = 'Image File type not allowed';
                }
                if ($image_size > 2097152) {
                  $errors[] = 'Maximum Image size is 2Mb';
                }

                if (empty($gender)) {
                  $errors[] = 'Gender Not Selected';
                }
                if (!empty($errors)) {
                  foreach ($errors as $error) {
              ?>
                    <div class="alert alert-danger"><?php echo $error; ?></div>
              <?php
                  }
                } else {
                  include 'includes/thumbs.func.php';
                  $addemployee =  mysqli_query($con, "INSERT INTO staff(fullname,phone,gender,email,ext,designation,status) VALUES('$fullname','$phone','$gender','$email','$image_ext','$designation','1')");
                  $last_id =  mysqli_insert_id($con);
                  if (!empty($image_name)) {
                    $image_file =  md5($last_id) . '.' . $image_ext;
                    move_uploaded_file($image_temp, 'images/nonteaching/' . $image_file) or die(mysqli_error($con));
                    create_thumb('images/nonteaching/', $image_file, 'images/nonteaching/thumbs/');
                  }
                  if (!empty($username)) {
                    if ($role == 4) {
                      $cat_id = $category;
                    } else {
                      $cat_id = 0;
                    }
                    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                    mysqli_query($con, "INSERT INTO users(staff_id,username,password,cat_id,level,status) VALUES('$last_id','$username','$hashed_password','$cat_id','$role','1')") or die(mysqli_error($con));
                  }
                  echo '<div class="alert alert-success">Staff Member successfully Added</div>';
                }
              }
              ?>

              <form method="post" name='form' class="form" action="" enctype="multipart/form-data">
                <div class="form-group"><label class="control-label">* Full Name</label>
                  <input type="text" name='fullname' class="form-control" placeholder="Enter fullname" required="required">
                </div>

                <div class="form-group"><label class="control-label">* Gender</label>

                  <select name="gender" class="form-control">
                    <option value="">select gender...</option>
                    <option value="Male">Male</option>
                    <option value="Female">Female</option>
                  </select>
                </div>



                <div class="form-group"><label class="control-label">*Phone</label>

                  <input type="text" name="phone" class="form-control" placeholder="Enter  phone Number" required="required">

                </div>

                <div class="form-group"><label class=" control-label">*Designation</label>

                  <input type="text" name="designation" class="form-control " placeholder="Enter Designation e.g Admin" required="required">

                </div>

                <div class="form-group"><label class="control-label"> Profile picture</label>
                  <input type="file" name="image" class="form-control " style="padding: 0px">
                </div>

                <div class="form-group"><label class="control-label"> Email Address</label>
                  <input type="email" name="email" class="form-control " placeholder="Enter a valid email address">
                  <div id='form_email_errorloc' class='text-danger'></div>
                </div>
                <h4>Fill this part below if member should access the system</h4>
                <div class="form-group"><label class=" control-label">* Username</label>

                  <input type="text" name="username" class="form-control" placeholder="Enter your username">

                </div>

                <div class="form-group"><label class="control-label">* Select Role</label>
                  <select name="role" class="form-control" id="role">
                    <option value="" selected="selected">Assign Role... </option>
                    <option value="1">Admin</option>
                    <!-- <option value="7">Head Teacher</option> -->
                    <option value="2">Principal</option>
                    <option value="3">Accounts Management</option>
                    <option value="4">Head of Section</option>
                    <option value="5">Librarian</option>
                    <!-- <option value="6">Secretary</option> -->
                    <option value="8">Finance</option>
                  </select>

                </div>

                <div class="cats" style="display: none">
                  <div class="form-group"><label class="control-label">* Select Section</label>
                    <select name="category" class="form-control" id="role">
                      <option value="" selected="selected">Select Section... </option>
                      <?php
                      $classes = mysqli_query($con, "SELECT * FROM classcategories WHERE status=1");
                      while ($row = mysqli_fetch_array($classes)) {
                        $classcategory_id = $row['classcategory_id'];
                        $classcategory = $row['classcategory'];
                      ?>
                        <option value="<?php echo $classcategory_id; ?>"><?php echo $classcategory; ?></option>
                      <?php } ?>
                    </select>

                  </div>
                </div>
                <div class="form-group"><label class="control-label">*Password</label>
                  <input type="password" name="password" class="form-control" placeholder="Enter  your password">
                  <div id='form_password_errorloc' class='text-danger'></div>
                </div>

                <div class="form-group"><label class="control-label"> *Repeat Password</label>

                  <input type="password" name="repeat" class="form-control" placeholder="Repeat your password">
                  <div id='form_repeat_errorloc' class='text-danger'></div>

                </div>
                <div class="form-group">
                  <button class="btn btn-primary" type="submit">Add Staff Member</button>
                </div>
              </form>
            </div>

        </div>
    </section>

    </div>

    </div>


    </div>
    <!-- page end-->
  </section>
  <!--body wrapper end-->

  <!--footer section start-->

  <!--footer section end-->


  </div>
  <!-- main content end-->
  </section>

  <script src="js/bootstrap.min.js"></script>
  <script src="js/modernizr.min.js"></script>
  <script src="js/jquery.nicescroll.js"></script>
  <script type="text/javascript" src="js/gen_validatorv4.js"></script>
  <script src="js/chosen/chosen.jquery.js"></script>

  <script src="js/scripts.js"></script>
  <script>
    var frmvalidator = new Validator("form");
    frmvalidator.EnableOnPageErrorDisplay();
    frmvalidator.EnableMsgsTogether();
    frmvalidator.addValidation("email", "email", "*Enter a valid  email address");
    //             frmvalidator.addValidation("password","minlength=6","*password  should atleast be 6 characters");
    frmvalidator.addValidation("repeat", "eqelmnt=password", "*The passwords dont match");
    $(document).ready(function() {
      var getval = $('#role').val();
      if (getval === '4') {
        $('.cats').show();
      }
      $('#role').on('change', function() {
        var getselect = $(this).val();
        if (getselect === '4') {
          $('.cats').show();
        } else {
          $('.cats').hide();
        }
      });
    });
  </script>
</body>

</html>