import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import react from '@vitejs/plugin-react';
import commonjs from 'vite-plugin-commonjs';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                //user theme
                'resources/css/app.css', 'resources/js/user/app.jsx',
                //admin theme
                'resources/css/admin.css', 'resources/js/admin/admin.jsx'
            ],
            refresh: true,
        }),
        commonjs(),
        react(),
    ],
    resolve:{
        alias: {
            '@': "/resources/js",
            '@user': "/resources/js/user/components",
            '@admin': "/resources/js/admin/components",
            // 'jquery': 'jquery/dist/jquery.min.js',
            '@inertiajs/react': '/node_modules/@inertiajs/react',
            // 'isotope-layout': 'isotope-layout/js/isotope',
        }
      },
});
