<?php

use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\CompanyInformationController;
use App\Http\Controllers\AccommodationController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\SubscriberController;
use App\Http\Controllers\GallaryController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\MenuItemController;
use App\Http\Controllers\Auth\ProfileController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SectionImageController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\EventRoomController;
use App\Http\Controllers\Admin\RoomController;
use App\Http\Controllers\Admin\PricingRuleController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\HomepageVideoController;
// Authentication
Route::get('/admin/login', [LoginController::class,'create'])->name('login');
Route::get('/admin/forgot_password', [LoginController::class,'create_forgot'])->name('forgot_password');
Route::post('/admin/forgot_password', [LoginController::class,'store_forgot'])->name('forgot_password');
Route::post('/admin/login', [LoginController::class,'store']);
//reset password
Route::get('/admin/reset-password/{token}', [LoginController::class, 'create_reset'])->name('password.reset');
Route::inertia('/admin/reset_success','auth/ConfirmSend')->name('confirm_send');
Route::post('/admin/reset-password', [LoginController::class, 'update'])->name('password.update');

//public apis
Route::get('/api/post_categories', [CategoryController::class, 'index']);
Route::post('/api/subscribe', [SubscriberController::class,'store']);
Route::post('/api/booking',[BookingController::class, 'store']);
Route::post('/api/contact',[ContactController::class,'submitContactForm']);
Route::get('/about-us', [HomeController::class, 'about']);

//user website routes
Route::get('/',[HomeController::class,'index']);
Route::inertia('/home','Test');
Route::get('/rooms', [HomeController::class, 'rooms']);
Route::get('/accommodations', [AccommodationController::class, 'index'])->name('accommodations');
Route::get('/accommodations/{id}', [AccommodationController::class, 'show'])->name('accommodation.show');
Route::inertia('/room-preview', 'AccommodationDetail'); // Preview with default data
Route::post('/api/check_accommodation_availability/{id}', [AccommodationController::class, 'checkAvailability']);
Route::get('/api/accommodations/{id}/available-rooms', [AccommodationController::class, 'getAvailableRooms']);
Route::get('/api/accommodations/available', [AccommodationController::class, 'getAllAvailableAccommodations']);
Route::get('/dining', [MenuItemController::class, 'index'])->name('dining');
Route::get('/meetings-events', [EventController::class, 'index'])->name('meetings-events');
Route::get('/meetings-events/{id}', [EventRoomController::class, 'show'])->name('event-room.show');
Route::inertia('/contact','Contact');
Route::get('/reservation', [HomeController::class, 'reservation']);


// Email preview routes (protected - admin only)
Route::prefix('admin')->middleware('auth:')->group(function () {
    Route::get('/preview-email/booking-confirmation', [BookingController::class, 'previewBookingConfirmation'])->name('preview.booking.confirmation');
    Route::get('/preview-email/booking-notification', [BookingController::class, 'previewBookingNotification'])->name('preview.booking.notification');
    Route::get('/preview-email/booking-status-update', [BookingController::class, 'previewBookingStatusUpdate'])->name('preview.booking.status');
});

// Admin routes
Route::prefix('admin')->name('admin.')->middleware('auth:')->group(function () {
    Route::get('/dashboard',[DashboardController::class,'fetchStats'])->name('dashboard');


    //accommodations
    Route::post('/api/accommodation/upload_image', [AccommodationController::class, 'uploadImage']);
    Route::post('/api/accommodation/upload_multiple', [AccommodationController::class, 'uploadMultipleImages']);
    Route::get('/accommodations',[AccommodationController::class,'fetchAccommodations'])->name('accommodations');
    Route::inertia('/accommodations/create','accommodations/create/Accommodation');
    Route::post('/accommodations/store',[AccommodationController::class,'store']);
    Route::get('/edit_accommodation/{id}', [AccommodationController::class, 'edit']);
    Route::put('/api/update_accommodation/{id}', [AccommodationController::class, 'update']);
    Route::delete('/api/delete_accommodation/{id}', [AccommodationController::class,'destroy']);
    Route::post('/api/check_accommodation_availability/{id}', [AccommodationController::class, 'checkAvailability']);

    //rooms (individual room instances)
    Route::get('/rooms',[RoomController::class,'index'])->name('rooms');
    Route::get('/rooms/create',[RoomController::class,'create']);
    Route::post('/rooms/store',[RoomController::class,'store']);
    Route::get('/edit_room/{id}', [RoomController::class, 'edit']);
    Route::put('/api/update_room/{id}', [RoomController::class, 'update']);
    Route::delete('/api/delete_room/{id}', [RoomController::class,'destroy']);

    //event rooms
    Route::post('/api/event_room/upload_image', [EventRoomController::class, 'uploadImage']);
    Route::post('/api/event_room/upload_multiple', [EventRoomController::class, 'uploadMultipleImages']);
    Route::get('/event_rooms',[EventRoomController::class,'fetchEventRooms'])->name('event_rooms');
    Route::inertia('/event_rooms/create','event_rooms/create/EventRoom');
    Route::post('/event_rooms/store',[EventRoomController::class,'store']);
    Route::get('/edit_event_room/{id}', [EventRoomController::class, 'edit']);
    Route::put('/api/update_event_room/{id}', [EventRoomController::class, 'update']);
    Route::delete('/api/delete_event_room/{id}', [EventRoomController::class,'destroy']);


    //bookings
    Route::get('/view_booking/{id}', [BookingController::class, 'edit']);
    Route::get('/bookings',[BookingController::class,'fetchBookings']);
    Route::get('/bookings/calendar',[BookingController::class,'calendar'])->name('bookings.calendar');
    Route::put('/confirm_booking/{id}', [BookingController::class, 'update']);
    Route::delete('/api/delete_booking/{id}', [BookingController::class,'destroy']);
    
    //testimonials
    Route::inertia('/testimonials/create','testimonials/create/Testimonial');
    Route::get('/testimonials',[TestimonialController::class,'fetchTestimonials'])->name('testimonials');
    Route::post('/api/testimonial/upload_image', [TestimonialController::class, 'uploadImage']);
    Route::post('/api/create_testimonial', [TestimonialController::class,'store']);
    Route::delete('/api/delete_testimonial/{id}', [TestimonialController::class,'destroy']);
    Route::get('/edit_testimonial/{id}', [TestimonialController::class, 'edit']);
    Route::put('/api/update_testimonial/{id}', [TestimonialController::class, 'update']);

    //menu items
    Route::get('/menus', [MenuItemController::class, 'fetchMenuItems'])->name('menus');
    Route::post('/api/create_menu_item', [MenuItemController::class, 'store']);
    Route::get('/edit_menu_item/{id}', [MenuItemController::class, 'edit']);
    Route::put('/api/update_menu_item/{id}', [MenuItemController::class, 'update']);
    Route::delete('/api/delete_menu_item/{id}', [MenuItemController::class, 'destroy']);

    //faqs
    Route::post('/api/create_faq', [FaqController::class,'store']);
    Route::inertia('/faqs/create', 'faqs/create/Faq');
    Route::get('/faqs',[FaqController::class,'fetchFaqs'])->name('faqs');
    Route::delete('/api/delete_faq/{id}', [FaqController::class,'destroy']);
    Route::get('/edit_faq/{id}', [FaqController::class, 'edit']);
    Route::put('/api/update_faq/{id}', [FaqController::class, 'update']);

    //services
    Route::get('/services',[ServiceController::class,'fetchServices'])->name('admin.services');
    Route::inertia('/services/create', 'services/create/Service');
    Route::post('/services/store', [ServiceController::class, 'store']);
    Route::get('/edit_service/{id}', [ServiceController::class, 'edit']);
    Route::put('/api/update_service/{id}', [ServiceController::class, 'update']);
    Route::delete('/api/delete_service/{id}', [ServiceController::class, 'destroy']);
    Route::post('/api/service/upload_image', [ServiceController::class, 'uploadImage']);

    //pricing rules
    Route::get('/pricing-rules',[PricingRuleController::class,'index'])->name('admin.pricing-rules');
    Route::get('/edit_pricing_rule/{id}', [PricingRuleController::class, 'edit']);
    Route::put('/api/update_pricing_rule/{id}', [PricingRuleController::class, 'update']);


    //posts
    Route::inertia('/post/create','posts/create/Post');
    Route::inertia('/post_category/create','posts/categories/create/Category');
    Route::get('/posts',[PostController::class,'fetchPosts'])->name('posts');
    Route::get('/post_category', [CategoryController::class,'fetchPostCategories'])->name('categories');
    Route::post('/api/create_post_category', [CategoryController::class,'store']);
    Route::post('/api/create_post', [PostController::class,'store']);
    Route::post('/api/post/upload_image', [PostController::class, 'uploadImage']);
    Route::delete('/api/delete_post_category/{id}', [CategoryController::class,'destroy']);
    Route::put('/api/update_post_category/{id}', [CategoryController::class, 'update']);
    Route::delete('/api/delete_post/{id}', [PostController::class,'destroy']);
    Route::get('/edit_post_category/{id}', [CategoryController::class, 'edit']);
    Route::put('/api/update_post/{id}', [PostController::class, 'update']);
    Route::get('/edit_post/{id}', [PostController::class, 'edit']);

    //events
    Route::inertia('/events/create','events/create/Event');
    Route::post('/api/event/upload_image', [EventController::class, 'uploadImage']);
    Route::post('/api/create_event', [EventController::class,'store']);
    Route::get('/events', [EventController::class,'fetchEvents'])->name('events');
    Route::delete('/api/delete_event/{id}', [EventController::class,'destroy']);
    Route::put('/api/update_event/{id}', [EventController::class, 'update']);
    Route::get('/edit_event/{id}', [EventController::class, 'edit']);
    
    //gallery
    Route::get('/gallery',[GallaryController::class,'fetchGallary'])->name('gallerys');
    Route::inertia('/gallery/create','galleries/create/Gallery');
    Route::post('/api/gallery/upload_image', [GallaryController::class, 'uploadImage']);
    Route::post('/api/create_gallery', [GallaryController::class,'store']);
    Route::delete('/api/delete_gallery/{id}', [GallaryController::class,'destroy']);
    Route::put('/api/update_gallery/{id}', [GallaryController::class, 'update']);
    Route::get('/edit_photo/{id}', [GallaryController::class, 'edit']);

    //banners
    Route::inertia('/banners/create','banners/create/Banner');
    Route::post('/api/banner/upload_image', [BannerController::class, 'uploadImage']);
    Route::post('/api/create_banner', [BannerController::class,'store']);
    Route::get('/banners',[BannerController::class,'fetchBanners'])->name('banners');
    Route::delete('/api/delete_banner/{id}', [BannerController::class,'destroy']);
    Route::put('/api/update_banner/{id}', [BannerController::class, 'update']);
    Route::get('/edit_banner/{id}', [BannerController::class, 'edit']);

    //sliders
    Route::inertia('/sliders/create','sliders/create/Slider');
    Route::post('/api/create_slider', [SliderController::class,'store']);
    Route::get('/sliders',[SliderController::class,'fetchSliders'])->name('sliders');
    Route::delete('/api/delete_slider/{id}', [SliderController::class,'destroy']);
    Route::put('/api/update_slider/{id}', [SliderController::class, 'update']);
    Route::get('/edit_slider/{id}', [SliderController::class, 'edit']);

    //homepage videos
    Route::get('/homepage_videos', [HomepageVideoController::class, 'index'])->name('homepage_videos');
    Route::post('/api/create_homepage_video', [HomepageVideoController::class, 'store']);
    Route::get('/edit_homepage_video/{id}', [HomepageVideoController::class, 'edit']);
    Route::post('/api/update_homepage_video/{id}', [HomepageVideoController::class, 'update']);
    Route::delete('/api/delete_homepage_video/{id}', [HomepageVideoController::class, 'destroy']);

    //messages
    Route::get('/messages', [ContactController::class, 'fetchMessages']);
    Route::get('/read_message/{id}', [ContactController::class,'read_message']);
    Route::post('/reply_message',[ContactController::class,'sendResponse']);
    Route::delete('/api/delete_message/{id}', [ContactController::class,'destroy']);

    //admin settings
    Route::middleware(['auth','role:admin'])->group(function () {
        //user management
        Route::get('/user', [ProfileController::class,'fetchUsers'])->name('users');
        Route::get('/edit_user/{id}', [ProfileController::class, 'edit']);
        Route::post('/api/create_user', [ProfileController::class,'store']);
        Route::post('/api/user/upload_image', [ProfileController::class, 'uploadImage']);
        Route::delete('api/delete_user/{id}', [ProfileController::class,'destroy']);
        Route::put('/api/update_user/{id}', [ProfileController::class, 'update'])->name('users.update');
        Route::inertia('/user/create', 'users/create/User');
        //company information
        Route::get('/company_info',[CompanyInformationController::class, 'edit']);
        Route::post('/update_company_info', [CompanyInformationController::class, 'update'])->name('update_company_info');
        //section images
        Route::post('/api/upload_home_about', [SectionImageController::class, 'uploadImage']);
        Route::post('/api/upload_about_page', [SectionImageController::class, 'uploadImage']);
        Route::post('/api/upload_besides_mission', [SectionImageController::class, 'uploadImage']);
        Route::post('/api/upload_hero_background', [SectionImageController::class, 'uploadImage']);
        Route::post('/api/upload_menu_background', [SectionImageController::class, 'uploadImage']);
        Route::post('/api/upload_menu_background_drinks', [SectionImageController::class, 'uploadMenuBackgroundDrinks']);
        Route::post('/api/upload_menu_background_desserts', [SectionImageController::class, 'uploadMenuBackgroundDesserts']);
        Route::post('/api/upload_cta_background', [SectionImageController::class, 'uploadImage']);
        Route::get('/section_image', [SectionImageController::class, 'edit']);
        Route::patch('/update_sectionimage', [SectionImageController::class, 'update']);

    });

    //fetch
    Route::get('/api/roles', [ProfileController::class, 'getRoles']);


    //user profile
    Route::get('/profile/edit',[ProfileController::class,'getProfile']);
    Route::put('/api/update_profile/{id}',[ProfileController::class,'updateProfile']);
    Route::post('/logout', [LoginController::class, 'destroy'])->middleware('auth');


});

// Fallback route
Route::fallback(function () {
    return Inertia::render('Error', ['status' => 404]);
})->name('fallback');
