<!DOCTYPE html>
<html>
<head>
    <title>Contact Form Submission</title>
    <style>
        body { font-family: Arial, sans-serif; color: #333; line-height: 1.6; }
        .container { max-width: 600px; margin: 0 auto; padding: 20px; }
        .header { background: #007BFF; padding: 15px; color: #fff; text-align: center; }
        .content { margin-top: 20px; background: #f9f9f9; padding: 20px; border-radius: 5px; }
        .field { margin-bottom: 15px; }
        .field strong { display: inline-block; width: 100px; }
        .message-box { background: #fff; padding: 15px; border-left: 4px solid #007BFF; margin-top: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>New Contact Form Submission</h2>
        </div>
        <div class="content">
            <div class="field">
                <strong>Subject:</strong> {{ $data['subject'] }}
            </div>
            <div class="field">
                <strong>Name:</strong> {{ $data['name'] }}
            </div>
            <div class="field">
                <strong>Email:</strong> {{ $data['email'] }}
            </div>
            @if(!empty($data['phone']))
            <div class="field">
                <strong>Phone:</strong> {{ $data['phone'] }}
            </div>
            @endif
            <div class="field">
                <strong>Message:</strong>
                <div class="message-box">
                    {{ $data['message'] }}
                </div>
            </div>
        </div>
        <div style="margin-top: 20px; font-size: 12px; color: #777; text-align: center;">
            <p>This message was sent from the contact form on your website.</p>
        </div>
    </div>
</body>
</html>
