import Availability from "@user/Availability";
import Facility from "@user/Facility";
import Testimonial from "@user/Testimonial";
import FooterPictures from "@user/FooterPictures";
import Intro from "@user/Intro";
import Welcome from "@user/Welcome";
import Event from "@user/Event";
import CTA from "@user/CTA";
import Menu from "@user/Menu";
import Photo from "@user/Photo";
import Rooms from "@user/Rooms";
import Services from "@user/Services";
import Video from "@user/Video";
import { usePage, Head } from "@inertiajs/react";

export default function Home(){
    const { banner, testimonials, menuFoodItems, menuDrinkItems, menuDessertItems, gallery, accommodations, eventRooms, services, videos } = usePage().props;
    return(
        <>
        <Head title="Home" />
        <Intro banner={banner} />
        <Availability />
        <Welcome />
        <Rooms accommodations={accommodations || []} />
        <Services services={services || []} />
        <Photo gallery={gallery || []} />
        <Menu 
            foodItems={menuFoodItems || []} 
            drinkItems={menuDrinkItems || []} 
            dessertItems={menuDessertItems || []} 
        />
        <Video videos={videos || []} />
        <Testimonial testimonials={testimonials} />
        <Event eventRooms={eventRooms || []} />
        <CTA />
        </>
    );
}   