import { usePage, Link } from '@inertiajs/react';

export default function Welcome({ showCta = true }){
    const { siteinfo, sectionimages } = usePage().props;
    
    // Get home image from section images
    const getHomeImage = () => {
        if (sectionimages?.home_about) {
            return `/storage/${sectionimages.home_about}`;
        }
        return 'https://placehold.co/800x800';
    };
    
    // Get rounded image - use about_page, or besides_mission as fallback, else placeholder
    const getRoundedImage = () => {
        if (sectionimages?.about_page) {
            return `/storage/${sectionimages.about_page}`;
        }
        if (sectionimages?.besides_mission) {
            return `/storage/${sectionimages.besides_mission}`;
        }
        return 'https://placehold.co/800x571';
    };
    
    // Get YouTube URL from company information
    const getYouTubeUrl = () => {
        if (siteinfo?.youtube) {
            return siteinfo.youtube;
        }
        return '#';
    };
    
    return(
        <>
        <section className="py-5 bg-light">
        <div className="container">
            <div className="row align-items-center">
            <div className="col-md-12 col-lg-7 ml-auto order-lg-2 position-relative mb-5" data-aos="fade-up">
                <figure className="img-absolute">
                <img src={getHomeImage()} alt="Image" className="img-fluid" />
                </figure>
                <img src={getRoundedImage()} alt="Image" className="img-fluid rounded" />
            </div>
            <div className="col-md-12 col-lg-4 order-lg-1" data-aos="fade-up">
                <h2 className="heading">Welcome!</h2>
                <p className="mb-4">{siteinfo?.introduction || 'Welcome to our establishment. We are dedicated to providing exceptional service and creating memorable experiences for our guests.'}</p>
                {showCta && (
                    <p>
                        <Link href="/about-us" className="btn btn-primary text-white py-2 mr-3">Learn More</Link> 
                        <span className="mr-3 font-family-serif"><em>or</em></span> 
                        <a href={getYouTubeUrl()} target="_blank" rel="noopener noreferrer" className="text-uppercase letter-spacing-1">See video</a>
                    </p>
                )}
            </div>
            
            </div>
        </div>
        </section>
        </>
    );
}