// Styles
// import '@/assets/css/stylename.css'



import { createInertiaApp } from '@inertiajs/react'
import { createRoot } from 'react-dom/client'
import UserLayout from './layouts/UserLayout'

createInertiaApp({
  title: title => title ? `${title} - Matergo Hotel` : 'Matergo Hotel',
  progress:{
    color: '#2596be',
  },
  
  resolve: name => {
    const pages = import.meta.glob('./pages/**/*.jsx', { eager: true })
    let page = pages[`./pages/${name}.jsx`]
    page.default.layout = page.default.layout || (page => <UserLayout children={page} />)
    return page
  },
  setup({ el, App, props }) {
    createRoot(el).render(<App {...props} />)
  },
})