import Card from "@admin/ui/Card";
import Col from "@admin/ui/Col";
import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { useFormResponse } from '@/hooks/useFormResponse';
export default function Slider(){
    const { data, setData, post, processing, errors, reset } = useForm({
        title: '',
        description:'',
        status: true,
    });
    
    const handleSubmit =(event) =>{
        event.preventDefault();
        const formResponse = useFormResponse(reset);
        post('/admin/api/create_slider',{
            ...formResponse,
            preserveScroll: true,
        });
    }

    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <h2 className="page-title">Sliders</h2>
            <p className="text-muted">Heading and description that shows in the home banner area</p>
            <Row>
            <Col lg="12">
            <Card md="6" title="Add new image">
            <form onSubmit={handleSubmit}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <FormGroup
            id="description"
            label="Description"
            as="textarea"
            value={data.description}
            helpText="Write brief paragraph."
            onChange={(e) => setData("description", e.target.value)}
            rows="4"
            invalidFeedback={errors.description}
            />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            <button type="submit" className="btn btn-primary " disabled={processing}>Save</button>
            </form>
            </Card>
            </Col>
            </Row>
            </Col>
        </Row>
        </>
    );
}