import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { useEffect } from "react";
import { toast, Toaster } from "react-hot-toast";
import { useFormResponse } from '@/hooks/useFormResponse';

export default function SectionImage({ section_images }) {
  const { data, setData, patch, processing, errors } = useForm({
    'home_about': '',
    'about_page': '',
    'besides_mission': '',
    'hero_background': '',
    'menu_background': '',
    'menu_background_drinks': '',
    'menu_background_desserts': '',
    'cta_background': '',
  });
  
  // Get form response outside of the handleSubmit function
  const formResponse = useFormResponse();
  
  useEffect(() => {
    if (section_images) {
      setData('home_about', section_images.home_about || '');
      setData('about_page', section_images.about_page || '');
      setData('besides_mission', section_images.besides_mission || '');
      setData('hero_background', section_images.hero_background || '');
      setData('menu_background', section_images.menu_background || '');
      setData('menu_background_drinks', section_images.menu_background_drinks || '');
      setData('menu_background_desserts', section_images.menu_background_desserts || '');
      setData('cta_background', section_images.cta_background || '');
    }
  }, [section_images, setData]);
  
  const handleHomeAboutSuccess = (filename) => {
    setData('home_about', filename);
  };
  
  const handleAboutPageSuccess = (filename) => {
    setData('about_page', filename);
  };
  
  const handlebBesidesMissionSuccess = (filename) => {
    setData('besides_mission', filename);
  };
  
  const handleHeroBackgroundSuccess = (filename) => {
    setData('hero_background', filename);
  };
  
  const handleMenuBackgroundSuccess = (filename) => {
    setData('menu_background', filename);
  };
  const handleMenuBackgroundDrinksSuccess = (filename) => {
    setData('menu_background_drinks', filename);
  };
  const handleMenuBackgroundDessertsSuccess = (filename) => {
    setData('menu_background_desserts', filename);
  };
  
  const handleCtaBackgroundSuccess = (filename) => {
    setData('cta_background', filename);
  };
  
  const handleError = (error) => {
    console.error("Upload error:", error);
  };
  
  const handleSubmit = (e) => {
    e.preventDefault();
    patch('/admin/update_sectionimage', {
      ...formResponse,
      preserveScroll: true,
    });
  };
  
  return (
    <>
      <Row col="12">
        <Col lg="12">
          <Toaster />
          <h2 className="page-title">Section Images</h2>
          <p className="text-muted">Update images that appear in the website section</p>
          <form onSubmit={handleSubmit}>
            <FileUploadInput 
              label="About Image (Homepage) (800x800)px"
              buttonText="Choose file (800x800)"
              uploadUrl="/admin/api/upload_home_about"
              onSuccess={handleHomeAboutSuccess}
              onError={handleError}
              previewUrl={data.home_about ? `/storage/${data.home_about}` : ''}
            />
            <FileUploadInput 
              label="About Page Image (800x571)px"
              buttonText="Choose file (800x571)"
              uploadUrl="/admin/api/upload_about_page"
              onSuccess={handleAboutPageSuccess}
              onError={handleError}
              previewUrl={data.about_page ? `/storage/${data.about_page}` : ''}
            />
            <FileUploadInput 
              label="Mission Image (800x571)px"
              buttonText="Choose file (800x571)"
              uploadUrl="/admin/api/upload_besides_mission"
              onSuccess={handlebBesidesMissionSuccess}
              onError={handleError}
              previewUrl={data.besides_mission ? `/storage/${data.besides_mission}` : ''}
            />
            <FileUploadInput 
              label="Hero Background Image (1900x1267)px"
              buttonText="Choose file (1900x1267)"
              uploadUrl="/admin/api/upload_hero_background"
              onSuccess={handleHeroBackgroundSuccess}
              onError={handleError}
              previewUrl={data.hero_background ? `/storage/${data.hero_background}` : ''}
            />
            <FileUploadInput 
              label="Menu Section Background Image (Food tab) (1900x1267)px"
              buttonText="Choose file (1900x1267)"
              uploadUrl="/admin/api/upload_menu_background"
              onSuccess={handleMenuBackgroundSuccess}
              onError={handleError}
              previewUrl={data.menu_background ? `/storage/${data.menu_background}` : ''}
              helpText="Background image for the Food tab in the Restaurant Menu section"
            />
            <FileUploadInput 
              label="Menu Section Background Image (Drinks tab) (1900x1267)px"
              buttonText="Choose file (1900x1267)"
              uploadUrl="/admin/api/upload_menu_background_drinks"
              onSuccess={handleMenuBackgroundDrinksSuccess}
              onError={handleError}
              previewUrl={data.menu_background_drinks ? `/storage/${data.menu_background_drinks}` : ''}
              helpText="Background image for the Drinks tab in the Restaurant Menu section"
            />
            <FileUploadInput 
              label="Menu Section Background Image (Desserts tab) (1900x1267)px"
              buttonText="Choose file (1900x1267)"
              uploadUrl="/admin/api/upload_menu_background_desserts"
              onSuccess={handleMenuBackgroundDessertsSuccess}
              onError={handleError}
              previewUrl={data.menu_background_desserts ? `/storage/${data.menu_background_desserts}` : ''}
              helpText="Background image for the Desserts tab in the Restaurant Menu section"
            />
            <FileUploadInput 
              label="CTA Section Background Image (1900x1267)px"
              buttonText="Choose file (1900x1267)"
              uploadUrl="/admin/api/upload_cta_background"
              onSuccess={handleCtaBackgroundSuccess}
              onError={handleError}
              previewUrl={data.cta_background ? `/storage/${data.cta_background}` : ''}
              helpText="Background image for the 'Reserve Now' call-to-action section"
            />
            <button type="submit" className="btn btn-primary" disabled={processing}>
              Update
            </button>
          </form>
        </Col>
      </Row>
    </>
  );
}