import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import Modal from "@admin/ui/Modal";
import { useEffect, useState } from "react";
import { useFormResponse } from '@/hooks/useFormResponse';
import { useForm } from "@inertiajs/react";

export default function EditCategory({ isOpen, onClose, initialData }){
    const {data, setData, put, processing, errors} = useForm({
        'title': '',
        'status': true,
    });

    useEffect(() => {
        if (initialData) {
          setData({
              title: initialData?.title || '',
              status: initialData?.status === 1,
          });
        }
    }, [initialData, setData]);

    const handleSave = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(() => {
            onClose?.(); 
        });
        put(`/admin/api/update_post_category/${initialData.id}`, {
            preserveScroll: true,
                onSuccess: formResponse.onSuccess, 
                onError: formResponse.onError, 
            });
    };

    return(
        <>
        <Modal isOpen={isOpen} onClose={onClose} title="Edit Category" size="large"
        primaryButtonText="Save Changes"
        onPrimaryAction={handleSave}
        processing={processing}
        >
            <form onSubmit={handleSave}>
            <FormGroup label="Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            </form>


        </Modal>
        </>
    );
}