import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";

import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditPost from "./EditPost";

export default function Post({posts}){
    const [postData, setPostData] = useState([]);
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, post: null });
    
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Title', key: 'title' },
        { header: 'Photo', key: 'photo' },
        { header: 'Status', key: 'status' },
      ];
    const handleEdit = (row) => {
    fetch(`/admin/edit_post/${row.id}`)
    .then((response) => {
        if (!response.ok) {
        throw new Error('Network response was not ok');
        }
        return response.json();
    })
    .then((postData) => {
        const formattedData = postData;
        setInitialData(formattedData);
        setIsEditModalOpen(true);
    })
    .catch((error) => {
        console.error('Error fetching post details:', error);
    });
};

      const handleDelete = (row) => {
        setDeleteModal({ show: true, post: row });
    };
    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Posts</h2>
            <p className="text-muted">Manage posts</p>
            <Link className="btn mb-4 btn-primary" href="/admin/post/create">
            Create new Post
            </Link>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={posts} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available Posts"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No Posts found"
                />
            </Col>
            </Row>
            </Col>
        </Row>

        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, post: null })}
            onConfirmDelete={() => {
                toast.success("Post Deleted Successfuly")
                setPostData(prev => prev.filter(item => item.id !== deleteModal.post.id));
            }}
            itemName={deleteModal.post?.title || 'this post'}
            itemType="post"
            deleteEndpoint={`/admin/api/delete_post/${deleteModal?.post?.id}`}
        />

        <EditPost  isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}/>

        </>
    );
}