import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";
import ReadMessage from "./ReadMessage";
import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
export default function Message({messages}){
    const [initialData, setInitialData] = useState(null);
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [deleteModal, setDeleteModal] = useState({ show: false, message: null });

    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Name', key: 'name' },
        { header: 'Email', key: 'email' },
        { header: 'Subject', key: 'subject' },
        { header: 'Viewed', key: 'is_read' },
      ];

      const handleRead = (row) => {
        fetch(`/admin/read_message/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((messageData) => {
            const formattedData = messageData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching message details:', error);
        });
    };

    const handleDelete = (row) => {
        setDeleteModal({ show: true, message: row });
    };

    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Messages</h2>
            <p className="text-muted"> View and respond to messages from the submitted contact forms</p>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={messages} 
                columns={columns} 
                itemsPerPage={5} 
                title="Received Messages"
                showEdit={false}
                showRead={true}
                onRead={handleRead}
                onDelete={handleDelete}
                noDataText="No Messages found"
                />
            </Col>
            </Row>
            </Col>
        </Row>

        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, message: null })}
            onConfirmDelete={() => {
                toast.success("Message Deleted Successfuly")
            }}
            itemName="this message"
            itemType="message"
            deleteEndpoint={`/admin/api/delete_message/${deleteModal?.message?.id}`}
        />
        
        <ReadMessage 
        isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
        initialData={initialData}
        />
        </>
    );
}