import Card from "@admin/ui/Card";
import Col from "@admin/ui/Col";
import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { useEffect, useState } from 'react';
import { useFormResponse } from '@/hooks/useFormResponse';
export default function Faq(){
    const {data,setData,post,processing,errors,reset} = useForm({
        question: '',
        answer: '',
        status: true,
    });

    const handleSubmit = (event) => {
        event.preventDefault();
        const formResponse = useFormResponse(reset);
        post('/admin/api/create_faq', {
            ...formResponse,
            preserveScroll: true, 
        });
    };
    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <h2 className="page-title">Frequently asked Questions</h2>
            {/* <p className="text-muted">Manage Post categories</p> */}
            <Row>
            <Col lg="12">
            <Card md="6" title="Add new FAQ">
            <form onSubmit={handleSubmit}>
            <FormGroup
                id="question"
                label="Question"
                as="textarea"
                value={data.question}
                onChange={(e) => setData("question", e.target.value)}
                rows="4"
                invalidFeedback={errors.question}
                />

            <FormGroup
                id="answer"
                label="Answer"
                as="textarea"
                value={data.answer}
                onChange={(e) => setData("answer", e.target.value)}
                rows="4"
                invalidFeedback={errors.answer}
                />
            
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            <button type="submit" className="btn btn-primary " disabled={processing}>Save</button>
            </form>
            </Card>
            </Col>
            </Row>
            </Col>
        </Row>
        </>
    );
}