import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { Link } from "@inertiajs/react";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";
import { toast,Toaster } from "react-hot-toast";
import { useState } from "react";
import EditFaq from "./EditFaq";

export default function Faq({faqs}){
    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Question', key: 'question' },
        { header: 'Answer', key: 'answer' },
        { header: 'Status', key: 'status' },
      ];

    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [initialData, setInitialData] = useState(null);
    const [deleteModal, setDeleteModal] = useState({ show: false, faq: null });
    
    const handleDelete = (row) => {
        setDeleteModal({ show: true, faq: row });
    };

    const handleEdit = (row) => {
        fetch(`/admin/edit_faq/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((faqData) => {
            const formattedData = faqData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching faqdetails:', error);
        });
    };

    return(
        <>
        <Row md="12" >
            <Col lg="12">
            <Toaster />
            <h2 className="page-title">Frequently Asked Questions</h2>
            <p className="text-muted">Manage FAQs</p>
            <Link className="btn mb-4 btn-primary" href="/admin/faqs/create">
            Create new FAQ
            </Link>
            <Row>
            <Col lg="12">
                <StyledTable 
                data={faqs} 
                columns={columns} 
                itemsPerPage={5} 
                title="Available FAQs"
                onEdit={handleEdit}
                onDelete={handleDelete}
                noDataText="No FAQs found"
                />
            </Col>
            </Row>
            </Col>
        </Row>

        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, faq: null })}
            onConfirmDelete={() => {
                toast.success("FAQ Deleted Successfuly")
            }}
            itemName= "this faq"
            itemType="faq"
            deleteEndpoint={`/admin/api/delete_faq/${deleteModal?.faq?.id}`}
        />
        <EditFaq isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
            initialData={initialData}/>
        </>
    );
}