import Card from "@admin/ui/Card";
import Col from "@admin/ui/Col";
import FormGroup from "@admin/ui/forms/FormGroup";
import Switch from "@admin/ui/forms/Switch";
import WysiwygEditor from "@admin/ui/forms/WysiwygEditor";
import FileUploadInput from "@admin/ui/forms/FileUploadInput";
import Row from "@admin/ui/Row";
import { useForm } from "@inertiajs/react";
import { Toaster } from "react-hot-toast";
import { useFormResponse } from '@/hooks/useFormResponse';

export default function Event(){
    const {data, setData,post, processing, errors,reset} = useForm({
        title: '',
        event_date: '',
        location: '',
        photo: '',
        description:'',
        status: true,
    });

    const today = new Date().toISOString().slice(0, 16);

    const handleSuccess = (filename) => {
        setData('photo',filename);
    };

     const handleError = (error) => {
        console.error("Upload error:", error);
    };

    const handleSubmit =(event) =>{
        event.preventDefault();
        const formResponse = useFormResponse(reset);
        post('/admin/api/create_event',{
            ...formResponse,
            preserveScroll: true,
        });
    }

    return(
        <>
        <Toaster />
        <Row md="12" >
            <Col lg="12">
            <h2 className="page-title">Create New Event</h2>
            <p className="text-muted">Add events to be displayed on the website</p>
            <Row>
            <Col lg="12">
            <Card md="6" title="New Event">
            <form onSubmit={handleSubmit}>
            <FormGroup label="Event Title" 
            value={data.title}
            onChange={(e) => setData('title', e.target.value)}
            invalidFeedback={errors.title}
            />

            <FormGroup
            id="event_date"
            label="Event Date and Time"
            as="input"
            type="datetime-local"
            value={data.event_date}
            min={today}  
            onChange={(e) => setData('event_date', e.target.value)}
            invalidFeedback={errors.event_date}
            helpText="Select the date and time the event is expected to happen. Past dates and times are not allowed."
            />

            <FormGroup label="Location" 
            value={data.location}
            onChange={(e) => setData('location', e.target.value)}
            helpText="Enter address for the event or virtual if its an online event"
            invalidFeedback={errors.location}
            />

            <br />
            <label className="label">Description (Required)</label>
            <WysiwygEditor
            value={data.description}
            onChange={description => setData('description', description)}
            height={400}
            placeholder="Write your description  here..."
            toolbar="full" />
            <br />
            <FileUploadInput label="Upload image (600x400)px" 
            buttonText={"Choose file (600x400)"}
            uploadUrl="/admin/api/event/upload_image"
            onSuccess={handleSuccess}
            onError={handleError}/>
            <Switch
            id="customSwitch"
            label="Active"
            checked={data.status}
            onChange={({ target: { checked } }) =>
                setData(prevData => ({ ...prevData, status: checked }))
                }                  
                />
                <br/>
            <button type="submit" className="btn btn-primary " disabled={processing}>Save</button>
            </form>
            </Card>
            </Col>
            </Row>
            </Col>
        </Row>
        </>
    );
}