import Col from "@admin/ui/Col";
import Row from "@admin/ui/Row";
import StyledTable from "@admin/ui/StyledTable";
import { toast,Toaster } from "react-hot-toast";
import DeleteConfirmationModal from "@admin/ui/DeleteConfirmationModal";
import { useState } from "react";
import ConfirmBooking from "./ConfirmBooking";

export default function Booking({bookings}){
    const [initialData, setInitialData] = useState(null);
    const [isEditModalOpen, setIsEditModalOpen] = useState(false);
    const [deleteModal, setDeleteModal] = useState({ show: false, booking: null });

    const columns = [
        { header: '', key: 'checkbox' },
        { header: 'Name', key: 'full_name' },
        { header: 'Email', key: 'email' },
        { header: 'Phone', key: 'phone' },
        { header: 'Accommodation', key: 'accommodation'},
        { header: 'Room', key: 'room'},
        { header: 'Booking Reference', key: 'booking_reference' },
        { header: 'Status', key: 'status'},
      ];

    const handleDelete = (row) => {
        setDeleteModal({ show: true, booking: row });
    };


    const handleConfirm = (row) => {
        fetch(`/admin/view_booking/${row.id}`)
        .then((response) => {
            if (!response.ok) {
            throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then((bookingData) => {
            const formattedData = bookingData;
            setInitialData(formattedData);
            setIsEditModalOpen(true);
        })
        .catch((error) => {
            console.error('Error fetching booking details:', error);
        });
    };
    return(
        <>
        <Toaster />
        <Row md="12">
            <Col lg="12">
            <StyledTable 
                data={bookings} 
                columns={columns} 
                itemsPerPage={5} 
                title="Bookings"
                showConfirm={true}
                showEdit={false}
                showSearch={true}
                onConfirm={handleConfirm}
                onRowClick={handleConfirm}
                onDelete={handleDelete}
                noDataText="No Bookings found"
                />
            </Col>
        </Row>

        <DeleteConfirmationModal isOpen={deleteModal.show} onClose={() => setDeleteModal({ show: false, booking: null })}
                onConfirmDelete={() => {
                    toast.success("Booking Deleted Successfuly")
                }}
                itemName={deleteModal.booking?.booking_reference || 'this booking'}
                itemType="booking"
                deleteEndpoint={`/admin/api/delete_booking/${deleteModal?.booking?.id}`}
            />

        <ConfirmBooking 
        isOpen={isEditModalOpen} onClose={() => setIsEditModalOpen(false)}
        initialData={initialData}/>

        </>
    );
}