import { Link, useForm } from "@inertiajs/react";

export default function ForgotPassword(){
    const {data, setData, post, processing, errors, reset} = useForm({
        'email': '',
    });

    function submit(e) {
        e.preventDefault();
        // Validate data before submission
        if (!data.email) {
            toast.error("Email is required, Please enter email");
            return;
        }
        post('/admin/forgot_password');
    }
    return(
        <>
        <div className="wrapper vh-100">
        <div className="row align-items-center h-100">
            <form className="col-lg-3 col-md-4 col-10 mx-auto text-center" onSubmit={submit}>
            <Link className="navbar-brand mx-auto mt-2 flex-fill text-center" href="#">
                <img src="/assets/user/images/matergo_website_logo.png" alt="Matergo Hotel" />
            </Link>
            <h2 className="my-3">Reset Password</h2>
            {errors.email && (
                <div className="alert alert-danger">
                    {errors.email}
                </div>
            )}
            <p className="text-muted">Please enter your email address below, and we will send you an email with instructions to reset your password.</p>
            <div className="form-group">
                <label for="inputEmail" className="sr-only">Email address</label>
                <input type="email" id="inputEmail" className="form-control form-control-lg" placeholder="Email address" required="" autofocus=""
                value={data.email}
                onChange={e => setData('email', e.target.value)} />
            </div>
            <button className="btn btn-lg btn-primary btn-block" type="submit" disabled={processing}>Reset Password</button>
            
            <p className="mt-5 mb-3 text-muted">© {new Date().getFullYear()}</p>
            </form>
        </div>
        </div>
        </>
    );
}