import Row from '../components/ui/Row';
import Col from '../components/ui/Col';
import Card from '../components/ui/Card';
import FormGroup from '../components/ui/forms/FormGroup';
import { useForm } from '@inertiajs/react';
import React, { useEffect } from 'react';
import { Toaster } from 'react-hot-toast';
import { useFormResponse } from '@/hooks/useFormResponse';


export default function CompanyInfo({company_information}) {
  const { data, setData, post, processing, errors } = useForm({
    introduction: '',
    youtube: '',
    mission: '',
    vision: '',
    objectives: '',
    address: '',
    phone: '',
    email: '',
    facebook: '',
    tiktok: '',
    instagram: '',
    story: '',
    about: '',
    map_embed_code: '',
    whatsapp_marketing: '',
    whatsapp_reception: '',
    menu_title: '',
    menu_description: '',
    cta_title: '',
    rooms_description: '',
    photos_description: '',
    offers_description: '',
    events_description: '',
  });

  useEffect(() => {
    setData('introduction', company_information?.introduction || '');
    setData('youtube', company_information?.youtube || '');
    setData('mission', company_information?.mission || '');
    setData('vision', company_information?.vision || '');
    setData('objectives', company_information?.objectives || '');
    setData('address', company_information?.address || '');
    setData('phone', company_information?.phone || ''); 
    setData('email', company_information?.email || ''); 
    setData('facebook', company_information?.facebook || '');
    setData('instagram', company_information?.instagram || '');
    setData('tiktok', company_information?.tiktok || '');
    setData('story', company_information?.story || '');
    setData('about', company_information?.about || '');
    setData('map_embed_code', company_information?.map_embed_code || '');
    setData('whatsapp_marketing', company_information?.whatsapp_marketing || '');
    setData('whatsapp_reception', company_information?.whatsapp_reception || '');
    setData('menu_title', company_information?.menu_title || '');
    setData('menu_description', company_information?.menu_description || '');
    setData('cta_title', company_information?.cta_title || '');
    setData('rooms_description', company_information?.rooms_description || '');
    setData('photos_description', company_information?.photos_description || '');
    setData('offers_description', company_information?.offers_description || '');
    setData('events_description', company_information?.events_description || '');

  },[company_information,setData]);

  const handleSubmit = (e) => {
    
    e.preventDefault();
    const formResponse = useFormResponse();
    post(`/admin/update_company_info`,{
      ...formResponse,    
      preserveScroll: true,
           
    }); 
  };

  return (
    <>
      <Row>
        <Toaster />
        <Col md="12">
          <h2 className="page-title">Company Information</h2>
          <p className="text-muted">Edit information about company profile</p>
          <Card title="Company Profile and Contact Details" lg="12">
            <form onSubmit={handleSubmit}>
                <Row>
                    <Col md="6">
                <FormGroup
                id="introduction"
                label="Introduction"
                as="textarea"
                value={data.introduction}
                helpText="Begin each paragraph on a new line."
                onChange={(e) => setData("introduction", e.target.value)}
                rows="4"
                invalidFeedback={errors.introduction}
                />
                <FormGroup
                id="mission"
                label="Mission"
                as="textarea"
                value={data.mission}
                onChange={(e) => setData("mission", e.target.value)}
                rows="2"
                // If you want to show a dynamic error message from Inertia, pass errors.introduction
                invalidFeedback={errors.mission}
                />
                <FormGroup
                id="vision"
                label="Vision"
                as="textarea"
                value={data.vision}
                onChange={(e) => setData("vision", e.target.value)}
                rows="2"
                invalidFeedback={errors.vision}
                />
                <FormGroup
                id="objectives"
                label="Objectives"
                as="textarea"
                value={data.objectives}
                onChange={(e) => setData("objectives", e.target.value)}
                rows="5"
                // If you want to show a dynamic error message from Inertia, pass errors.introduction
                invalidFeedback={errors.objectives}
                />
                <FormGroup
                id="story"
                label="Story"
                as="textarea"
                value={data.story}
                onChange={(e) => setData("story", e.target.value)}
                rows="4"
                helpText="Tell your company's story and journey."
                invalidFeedback={errors.story}
                />
                <FormGroup
                id="about"
                label="About"
                as="textarea"
                value={data.about}
                onChange={(e) => setData("about", e.target.value)}
                rows="4"
                helpText="Detailed information about your company."
                invalidFeedback={errors.about}
                />

                </Col>
                <Col md="6">
                <FormGroup
                  id="email"
                  label="Email"
                  type="email"
                  value={data.email}
                  onChange={(e) => setData("email", e.target.value)}
                  invalidFeedback={errors.email}
                />
                <FormGroup
                  id="address"
                  label="Address"
                  type="text"
                  value={data.address}
                  onChange={(e) => setData("address", e.target.value)}
                  invalidFeedback={errors.address}
                />
                <FormGroup
                  id="photo"
                  label="Phone"
                  type="text"
                  value={data.phone}
                  onChange={(e) => setData("phone", e.target.value)}
                  invalidFeedback={errors.phone}
                />
                <FormGroup
                  id="whatsapp_marketing"
                  label="WhatsApp Marketing"
                  type="text"
                  value={data.whatsapp_marketing}
                  onChange={(e) => setData("whatsapp_marketing", e.target.value)}
                  invalidFeedback={errors.whatsapp_marketing}
                  helpText="Marketing WhatsApp number (e.g., +257 22 40 51 77)"
                />
                <FormGroup
                  id="whatsapp_reception"
                  label="WhatsApp Reception"
                  type="text"
                  value={data.whatsapp_reception}
                  onChange={(e) => setData("whatsapp_reception", e.target.value)}
                  invalidFeedback={errors.whatsapp_reception}
                  helpText="Reception/Front Desk WhatsApp number (e.g., +257 62 94 46 91)"
                />
                <FormGroup
                  id="instagram"
                  label="Instagram"
                  type="text"
                  value={data.instagram}
                  onChange={(e) => setData("instagram", e.target.value)}
                  invalidFeedback={errors.instagram}
                />
                <FormGroup
                  id="facebook"
                  label="Facebook"
                  type="text"
                  value={data.facebook}
                  onChange={(e) => setData("facebook", e.target.value)}
                  invalidFeedback={errors.facebook}
                />
                <FormGroup
                  id="youtube"
                  label="Youtube"
                  type="text"
                  value={data.youtube}
                  onChange={(e) => setData("youtube", e.target.value)}
                  invalidFeedback={errors.youtube}
                />

                <FormGroup
                  id="tiktok"
                  label="Tiktok"
                  type="text"
                  value={data.tiktok}
                  onChange={(e) => setData("tiktok", e.target.value)}
                  invalidFeedback={errors.tiktok}
                />
                <FormGroup
                  id="map_embed_code"
                  label="Map Embed Code"
                  as="textarea"
                  value={data.map_embed_code}
                  onChange={(e) => setData("map_embed_code", e.target.value)}
                  rows="4"
                  helpText="Paste the embed code from Google Maps or other mapping services."
                  invalidFeedback={errors.map_embed_code}
                />


                </Col>
              </Row>

              {/* Section Descriptions */}
              <Row className="mt-4">
                <Col md="12">
                  <h4 className="mb-3">Section Titles & Descriptions</h4>
                  <p className="text-muted small mb-4">Customize titles and descriptions for different sections on the homepage</p>
                </Col>
              </Row>

              <Row>
                <Col md="6">
                  <FormGroup
                    id="menu_title"
                    label="Menu Section Title"
                    type="text"
                    value={data.menu_title}
                    onChange={(e) => setData("menu_title", e.target.value)}
                    invalidFeedback={errors.menu_title}
                    helpText="Title for the Restaurant Menu section (e.g., 'Our Restaurant Menu')"
                  />
                  <FormGroup
                    id="menu_description"
                    label="Menu Section Description"
                    as="textarea"
                    value={data.menu_description}
                    onChange={(e) => setData("menu_description", e.target.value)}
                    rows="3"
                    invalidFeedback={errors.menu_description}
                    helpText="Description shown below the menu section title"
                  />
                  <FormGroup
                    id="cta_title"
                    label="CTA Section Title"
                    type="text"
                    value={data.cta_title}
                    onChange={(e) => setData("cta_title", e.target.value)}
                    invalidFeedback={errors.cta_title}
                    helpText="Title for the call-to-action section (e.g., 'A Best Place To Stay. Reserve Now!')"
                  />
                </Col>
                <Col md="6">
                  <FormGroup
                    id="rooms_description"
                    label="Rooms Section Description"
                    as="textarea"
                    value={data.rooms_description}
                    onChange={(e) => setData("rooms_description", e.target.value)}
                    rows="3"
                    invalidFeedback={errors.rooms_description}
                    helpText="Description shown below the Rooms & Suites section title"
                  />
                  <FormGroup
                    id="photos_description"
                    label="Photos Section Description"
                    as="textarea"
                    value={data.photos_description}
                    onChange={(e) => setData("photos_description", e.target.value)}
                    rows="3"
                    invalidFeedback={errors.photos_description}
                    helpText="Description shown below the Photos section title"
                  />
                  <FormGroup
                    id="offers_description"
                    label="Offers Section Description"
                    as="textarea"
                    value={data.offers_description}
                    onChange={(e) => setData("offers_description", e.target.value)}
                    rows="3"
                    invalidFeedback={errors.offers_description}
                    helpText="Description shown below the Great Offers section title"
                  />
                  <FormGroup
                    id="events_description"
                    label="Events Section Description"
                    as="textarea"
                    value={data.events_description}
                    onChange={(e) => setData("events_description", e.target.value)}
                    rows="3"
                    invalidFeedback={errors.events_description}
                    helpText="Description shown below the Events/Meeting Rooms section title"
                  />
                </Col>
              </Row>
              
              <button type="submit" className="btn btn-primary" disabled={!data || processing}>
                  Save
                </button>
            </form>
          </Card>
        </Col>
      </Row>
    </>
  );
}
