import React from 'react';

const FormGroup = ({
  id,
  label,
  type = "text",
  as: Component = "input", // default to input
  children, // for elements like select that need options, etc.
  value,
  onChange,
  placeholder = "",
  required = false,
  invalidFeedback,
  validFeedback,
  helpText,
  rows = "",
  className = "",
  ...rest
}) => {
  const inputClass = `form-control ${invalidFeedback ? 'is-invalid' : ''}`;

  return (
    <div className={`form-group ${className}`}>
      <label htmlFor={id}>{label}</label>
      <Component
        type={Component === "input" ? type : undefined}
        className={inputClass}
        id={id}
        placeholder={placeholder}
        value={value}
        rows={rows}
        onChange={onChange}
        required={required}
        {...rest}
      >
        {children}
      </Component>
      {invalidFeedback && <div className="invalid-feedback">{invalidFeedback}</div>}
      {validFeedback && <div className="valid-feedback">{validFeedback}</div>}
      {helpText && (
        <small id={`${id}Help`} className="form-text text-muted">
          {helpText}
        </small>
      )}
    </div>
  );
};

export default FormGroup;
