import { createInertiaApp } from '@inertiajs/react'
import { createRoot } from 'react-dom/client'
import DashboardLayout from './layouts/DashboardLayout'


createInertiaApp({
  progress: {
    color: '#4336FB',
    showSpinner: true,
  },
  resolve: name => {
    const pages = import.meta.glob('./pages/**/*.jsx', { eager: true })
    let page = pages[`./pages/${name}.jsx`]
    
    // List of page names to exclude from DashboardLayout
    const excludedPages = ['auth/Login','auth/ForgotPassword','auth/Reset','auth/ConfirmSend']

    // Only apply DashboardLayout if the page is not in the excluded list
    if (!excludedPages.includes(name)) {
      page.default.layout = page => <DashboardLayout>{page}</DashboardLayout>
    }
    return page
  },
  setup({ el, App, props }) {
    createRoot(el).render(<App {...props} />)
  },
})