(function($) {

	'use strict';

  // Use event delegation for menu toggle (only bind once)
  if (!window.menuToggleBound) {
    $(document).on('click', '.site-menu-toggle', function(){
      var $this = $(this);
      if ( $('body').hasClass('menu-open') ) {
        $this.removeClass('open');
        $('.js-site-navbar').fadeOut(400);
        $('body').removeClass('menu-open');
      } else {
        $this.addClass('open');
        $('.js-site-navbar').fadeIn(400);
        $('body').addClass('menu-open');
      }
    });
    window.menuToggleBound = true;
  }

  // Use event delegation for dropdown hover
  if (!window.dropdownBound) {
    $(document).on('mouseenter', 'nav .dropdown', function(){
      var $this = $(this);
      $this.addClass('show');
      $this.find('> a').attr('aria-expanded', true);
      $this.find('.dropdown-menu').addClass('show');
    }).on('mouseleave', 'nav .dropdown', function(){
      var $this = $(this);
      $this.removeClass('show');
      $this.find('> a').attr('aria-expanded', false);
      $this.find('.dropdown-menu').removeClass('show');
    });
    window.dropdownBound = true;
  }

  // Use event delegation for smooth scroll
  if (!window.smoothScrollBound) {
    $(document).on('click', 'a.smoothscroll[href^="#"]', function(e) {
      e.preventDefault();
      var target = $($.attr(this, 'href'));
      if (target.length) {
        $('html, body').animate({
          scrollTop: target.offset().top
        }, 500);
      }
    });
    window.smoothScrollBound = true;
  }

  // Use event delegation for go to top
  if (!window.goToTopBound) {
    $(document).on('click', '.js-gotop', function(event){
      event.preventDefault();
      $('html, body').animate({
        scrollTop: $('html').offset().top
      }, 500, 'easeInOutExpo');
      return false;
    });
    window.goToTopBound = true;
  }

  // Window scroll handler (only bind once)
  if (!window.windowScrollBound) {
    $(window).on('scroll', function(){
      var $win = $(window);
      if ($win.scrollTop() > 200) {
        $('.js-site-header').addClass('scrolled');
        $('.js-top').addClass('active');
      } else {
        $('.js-site-header').removeClass('scrolled');
        $('.js-top').removeClass('active');
      }
    });
    window.windowScrollBound = true;
  }

  // Function to initialize plugins
  window.initializeMainPlugins = function() {
    // Initialize AOS
    if (typeof AOS !== 'undefined') {
      AOS.init({
        duration: 1000
      });
    }

    // Home slider
    if ($('.home-slider').length && !$('.home-slider').hasClass('owl-loaded')) {
      $('.home-slider').owlCarousel({
        loop: true,
        autoplay: true,
        margin: 10,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        nav: true,
        autoplayHoverPause: true,
        items: 1,
        autoHeight: true,
        navText: ["<span class='ion-chevron-left'></span>", "<span class='ion-chevron-right'></span>"],
        responsive: {
          0: { items: 1, nav: false },
          600: { items: 1, nav: false },
          1000: { items: 1, nav: true }
        }
      });
    }

    // Carousel 1
    if ($('.js-carousel-1').length && !$('.js-carousel-1').hasClass('owl-loaded')) {
      $('.js-carousel-1').owlCarousel({
        loop: true,
        autoplay: true,
        stagePadding: 7,
        margin: 20,
        animateOut: 'fadeOut',
        animateIn: 'fadeIn',
        nav: true,
        autoplayHoverPause: true,
        items: 3,
        navText: ["<span class='ion-chevron-left'></span>", "<span class='ion-chevron-right'></span>"],
        responsive: {
          0: { items: 1, nav: false },
          600: { items: 2, nav: false },
          1000: { items: 3, nav: true, loop: false }
        }
      });
    }

    // Carousel 2 (Testimonials)
    if ($('.js-carousel-2').length && !$('.js-carousel-2').hasClass('owl-loaded')) {
      $('.js-carousel-2').owlCarousel({
        loop: true,
        autoplay: true,
        stagePadding: 7,
        margin: 20,
        nav: true,
        autoplayHoverPause: true,
        autoHeight: true,
        items: 3,
        navText: ["<span class='ion-chevron-left'></span>", "<span class='ion-chevron-right'></span>"],
        responsive: {
          0: { items: 1, nav: false },
          600: { items: 2, nav: false },
          1000: { items: 3, dots: true, nav: true, loop: false }
        }
      });
    }

    // Stellar parallax
    if ($.fn.stellar) {
      $(window).stellar({
        responsive: false,
        parallaxBackgrounds: true,
        parallaxElements: true,
        horizontalScrolling: false,
        hideDistantElements: false,
        scrollProperty: 'scroll'
      });
    }

    // Datepickers
    if ($.fn.datepicker) {
      $('#m_date').datepicker({
        format: 'm/d/yyyy',
        autoclose: true
      });
      $('#checkin_date, #checkout_date').datepicker({
        format: 'd MM, yyyy',
        autoclose: true
      });
    }

    // Timepicker
    if ($.fn.timepicker) {
      $('#m_time').timepicker();
    }

    // Fancybox
    if ($.fn.fancybox) {
      $('[data-fancybox]').fancybox();
    }

    // Hide preloader
    setTimeout(function() {
      $('#preloder').fadeOut('slow', function() {
        $(this).css('display', 'none');
      });
    }, 100);
  };

  // Initial setup on page load
  $(document).ready(function() {
    window.initializeMainPlugins();
  });

})(jQuery);
