<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('menu_items', function (Blueprint $table) {
            $table->decimal('price_fbu', 12, 2)->nullable()->after('category');
            $table->decimal('price_usd', 12, 2)->nullable()->after('price_fbu');
            $table->decimal('price_eur', 12, 2)->nullable()->after('price_usd');
        });

        // Backfill USD from legacy price column for existing records
        DB::table('menu_items')->update([
            'price_usd' => DB::raw('price'),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('menu_items', function (Blueprint $table) {
            $table->dropColumn(['price_fbu', 'price_usd', 'price_eur']);
        });
    }
};
