<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('company_information', function (Blueprint $table) {
            $table->string('menu_title')->nullable()->after('map_embed_code');
            $table->text('menu_description')->nullable()->after('menu_title');
            $table->string('cta_title')->nullable()->after('menu_description');
            $table->text('rooms_description')->nullable()->after('cta_title');
            $table->text('photos_description')->nullable()->after('rooms_description');
            $table->text('offers_description')->nullable()->after('photos_description');
            $table->text('events_description')->nullable()->after('offers_description');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('company_information', function (Blueprint $table) {
            $table->dropColumn([
                'menu_title',
                'menu_description',
                'cta_title',
                'rooms_description',
                'photos_description',
                'offers_description',
                'events_description'
            ]);
        });
    }
};
