<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('event_rooms', function (Blueprint $table) {
            // Add EUR price field after price_usd for consistency
            $table->decimal('price_eur', 10, 2)->nullable()->after('price_usd');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('event_rooms', function (Blueprint $table) {
            $table->dropColumn('price_eur');
        });
    }
};
