<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Check if table exists and columns don't already exist
        if (Schema::hasTable('bookings')) {
            Schema::table('bookings', function (Blueprint $table) {
                // Only modify if column doesn't exist
                if (!Schema::hasColumn('bookings', 'price')) {
                    $table->decimal('price', 10, 2)->after('email');
                }
                // Only modify email if it's not already nullable
                if (Schema::hasColumn('bookings', 'email')) {
                    $table->string('email')->nullable()->change();
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('bookings', function (Blueprint $table) {
            //
            $table->string('email')->nullable(false)->change(); 
            $table->dropColumn('price');
        });
    }
};
