<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PricingRule extends Model
{
    protected $fillable = [
        'accommodation_id',
        'base_price_bif',
        'base_price_usd',
        'base_price_eur',
        'additional_adult_bif',
        'additional_adult_usd',
        'additional_adult_eur',
        'child_surcharge_bif',
        'child_surcharge_usd',
        'child_surcharge_eur',
    ];

    protected $casts = [
        'base_price_bif' => 'decimal:2',
        'base_price_usd' => 'decimal:2',
        'base_price_eur' => 'decimal:2',
        'additional_adult_bif' => 'decimal:2',
        'additional_adult_usd' => 'decimal:2',
        'additional_adult_eur' => 'decimal:2',
        'child_surcharge_bif' => 'decimal:2',
        'child_surcharge_usd' => 'decimal:2',
        'child_surcharge_eur' => 'decimal:2',
    ];

    /**
     * Get the accommodation this pricing rule belongs to
     */
    public function accommodation()
    {
        return $this->belongsTo(Accommodation::class);
    }

    /**
     * Calculate price based on guest count and currency
     * 
     * @param int $adults
     * @param int $children
     * @param string $currency (bif, usd, eur)
     * @return float
     */
    public function calculatePrice($adults, $children, $currency = 'bif')
    {
        $basePrice = $this->{"base_price_{$currency}"} ?? 0;
        $additionalAdults = max(0, $adults - 1);
        $additionalAdultPrice = ($this->{"additional_adult_{$currency}"} ?? 0) * $additionalAdults;
        $childrenPrice = ($this->{"child_surcharge_{$currency}"} ?? 0) * $children;
        
        return $basePrice + $additionalAdultPrice + $childrenPrice;
    }
}
